/***************************************************************************//**
 * @file mp3player.c
 * @brief MP3 Player runs on EFM32PG12 or EFM32GG11 STK
 * @version  1.00

 *******************************************************************************
 * # License
 * <b>Copyright 2017 Silicon Laboratories, Inc. http://www.silabs.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 ******************************************************************************/

#include "mp3config.h"

/**************************************************************************//**
 * @brief  Main function
 *****************************************************************************/
int main(void)
{
  // Initialize chip
  CHIP_Init();

#if defined(_EMU_DCDCCTRL_MASK)
  // Initialize DCDC regulator if available
  EMU_DCDCInit_TypeDef dcdcInit = EMU_DCDCINIT_DEFAULT;
  EMU_DCDCInit(&dcdcInit);
#endif

#if defined (MSC_CTRL_IFCREADCLEAR)  
  // Enable atomic read-clear operation on reading IFC register
  MSC->CTRL |= MSC_CTRL_IFCREADCLEAR;
#endif
  
#if (AUDIO_OUTPUT_SELECT == 1)
  // Enable LFXO and wait it ready, use as DPLL reference clock
  CMU_OscillatorEnable(cmuOsc_LFXO, true, true);
  // Default DPLL HFRCO frequency is for 48 KHz I2S
  setupI2sDpll(48000);
#else
  // Use HFRCO as core clock frequency
  CMU_HFRCOBandSet(VDAC_HFRCO);
#endif
  
  // Enable required peripherals' clocks
  CMU_ClockEnable(cmuClock_LDMA, true);
#if (AUDIO_OUTPUT_SELECT == 1)
  CMU_ClockEnable(I2S_CMUCLOCK, true);
  CMU_ClockEnable(cmuClock_GPIO, true);
#else
  CMU_ClockEnable(cmuClock_VDAC0, true);
  CMU_ClockEnable(cmuClock_PRS, true);
  CMU_ClockEnable(TIMER_CLOCK, true);
#endif

  // Initialize the display module
  DISPLAY_Init();

  // Retarget stdio to a text display
  if (RETARGET_TextDisplayInit() != TEXTDISPLAY_EMSTATUS_OK)
  {
    // Text display initialization failed
    while (1);
  }

  // Initialize LDMA
  LDMA_Init_t init = LDMA_INIT_DEFAULT;
  LDMA_Init(&init);

  // Initial I2S or VDAC
#if (AUDIO_OUTPUT_SELECT == 1)
  setupI2s();
#if  (I2S_CODEC_SELECT == 1)
  setupCodec();
#endif
#else
  setupVdac();
#endif
  // Start decoding MP3 file from storage media
  mp3DecodeFromMedia();
}
