/*********************************************************************************
|*
|*  File        :  _iowrite.c
|*
|*  Version     :  1.7
|*
|*  Description :  Source file for _iowrite() routine
|*                 Low level output routine. Is used by all printing
|*                 routines.
|*                 This routine should be customised.
|*                 This file has been customised for Cygnal Application Note 043
|*
|*  Copyright 1999-2003 Altium BV
|*
 *********************************************************************************/

#include <stdio.h>
#include <simio.h>
#include "regc51f12x.sfr"

#define XON  0x11
#define XOFF 0x13

_regparm int
_iowrite( int c, FILE *stream )
{
 // expands '\n' into CR LF and handles
 // XON/XOFF (Ctrl+S/Ctrl+Q) protocol

  if (c == '\n')  {
    if (RI0)  {
      if (SBUF0 == XOFF)  {
        do  {
          RI0 = 0;
          while (!RI0);
        }
        while (SBUF0 != XON);
        RI0 = 0; 
      }
    }
    while (!TI0);
    TI0 = 0;
    SBUF0 = 0x0d;                         /* output CR  */
  }
  if (RI0)  {
    if (SBUF0 == XOFF)  {
      do  {
        RI0 = 0;
        while (!RI0);
      }
      while (SBUF0 != XON);
      RI0 = 0; 
    }
  }
  while (!TI0);
  TI0 = 0;
  return (SBUF0 = c);
}
