# 1 "stub.asm"
;
;  Version:  
;
;  Copyright 1999-2002 Altium BV
;
;  This file has been modified to allow for bank switching on Cygnal 
;  8051 devices.
;
;  EDIT: JM
;  DATE: 19 AUG 03
; 
$CASE
	
;
;
	NAME _STUB

	PUBLIC	__LK_STUB_ENTRY

EXTRN	CODE(__LK_FUNCTION_ADDRESS)
EXTRN	DATA(__LK_FUNCTION_BANK)




# 20 "stub.asm"
	

	BANK_SFR	EQU	0B1h        ; PSBANK (on all SFR pages)

# 26 "stub.asm"

;************************************************************************
;									                                                      *
;		__LK_STUB						                                                *
;									                                                      *
;	This routine is inserted for every CALL from one segment to a	        *
;	segment in another bank. The variable __LK_FUNCTION_ADDRESS	          *
;	will be resolved with the 16-bit offset of the called label.	        *
;									                                                      *
;************************************************************************

__LK_STUB SEGMENT CODE
	RSEG	__LK_STUB
__LK_STUB_ENTRY:
	MOV	DPTR,#__LK_FUNCTION_ADDRESS
	JMP	__LK_BANKSWITCH


;************************************************************************
;									                                                      *
;		__BANKSW						                                                *
;									                                                      *
;	This routine takes care of the actual switching of code-banks.	      *
;	This will depend on the hardware implementation. This example         *
;	uses the SFR PSBANK to select the code bank. This is the    	        *
;	method supported by the Cygnal 8051 devices.                          *
;									                                                      *
;************************************************************************

__BANKSW	SEGMENT	CODE
	RSEG	__BANKSW
__LK_BANKSWITCH:
	PUSH	BANK_SFR			              ; push current bank
	CALL	_bankswitch
	POP	BANK_SFR			                ; switch back to original bank
	RET

_bankswitch:
  PUSH ACC
	MOV A, #__LK_FUNCTION_BANK        ; put new value in IFBANK
  RL A
	RL A
	RL A
	RL A
  ADD A, #__LK_FUNCTION_BANK        ; put new value in COBANK
	
	MOV	BANK_SFR, A	; switch to new instruction fetch bank

  POP ACC
	PUSH	DPL
	PUSH	DPH
	RET

	END
