//-----------------------------------------------------------------------------
// PS_V1.3.h
//-----------------------------------------------------------------------------
//
// AUTH: FB
// DATE: 26 JUN 03
// 
// VERSION: 1.3.0
// 
// Header file contianing configuration settings for Power Sequencing 
// Software (PS_V1.3.c).
//  
// Target: C8051F330 and C8051F300
// Tool chain: KEIL C51   
//

// Step 1 - Select a device
#define F330                     1        // Select '1' for the 'F330 and
                                          // select '0' for the 'F300
                                          
// Step 2 - Select features to enable on the 'F330. Note that these features are 
// not available for the 'F300.
#if(F330)
   #define UART_ENABLE           0        // Enables configuration through UART
   #define THREE_CHANNEL         1        // Enables the third channel
#endif // F330

// Step 3 - Define System Parameters for the 'F330 and the 'F300

#define DEFAULT_RAMP_RATE        500      // Default ramp rate in V/s
#define DEFAULT_VAL_WAITTIME     100      // Default validation wait time in ms
#define DEFAULT_MON_WAITTIME     100      // Default time between POWER_G and 
                                          // S_RESET rising edge in ms.

#define OVERVOLTAGE_PROTECTION   1        // Enable or Disable Overvoltage Protection 
#define OVERCURRENT_PROTECTION   1        // Enable or Disable Overcurrent protection

#define RAMP_TIMEOUT_ENABLE      1        // Enables Ramp Timeout
#define RAMP_TIMEOUT             100      // Maximum time allowed for ramping (ms)

#define NUM_RETRIES              3        // The number of power-up retries the system
                                          // will attempt after a power failure

// The minimum specified Target voltage for each channel (-8% of target voltage)
#define CH1_VTARGET_MIN          3036L    // Channel 1 min target voltage in mV
#define CH2_VTARGET_MIN          1656L    // Channel 2 min target voltage in mV
#define CH3_VTARGET_MIN          1380L    // Channel 3 min target voltage in mV

// The maximum specified Target voltage for each channel (+8% of target voltage)
#define CH1_VTARGET_MAX          3564L    // Channel 1 max target voltage in mV
#define CH2_VTARGET_MAX          1944L    // Channel 2 max target voltage in mV
#define CH3_VTARGET_MAX          1620L    // Channel 3 max target voltage in mV

                                          
#define OVERCURRENT_VTH          400L     // Overcurrent threshold in mV 

#define STRICT_VAL_DELTA         100L     // Overvoltage threshold is decreased and
                                          // undervoltage threshold is increased by  
                                          // this amount after a power failure

// Resistor values for the attenuator on CH1
#define R10                      2800L    // Resistance in Ohms
#define R11                      5360L    // Resistance in Ohms





