//-----------------------------------------------------------------------------
// FIR_Constants.h
//-----------------------------------------------------------------------------
// Copyright 2006 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// File Description:
// --------------------
//
// These FIR filter constants were generated using MATLAB's FDATool (Filter
// Design and Analysis Tool).  They were generated using a modified
// least-squares algorithm.
//
// Target:         C8051F362 (TOOLSTICK360DC) / C8051F120 ('F120 TB)
// Tool chain:     Keil C51 7.50 / Keil EVAL C51 / SDCC
// Command Line:   None
//
// Release 1.0
//    -Initial Revision (TP / GV)
//    -04 FEB 2007

//-----------------------------------------------------------------------------
// Low-pass FIR Filters
//-----------------------------------------------------------------------------

// 5th Order FIR Low-pass Filter
/*
#define TAPS 6

code const SI_UU16_t B_FIR[TAPS] = {
                              {268},
                              {4744},
                              {11536},
                              {11536},
                              {4744},
                              {268},
                              };
*/

// 10th Order FIR Low-pass Filter

#define TAPS 11

code const SI_UU16_t B_FIR[TAPS] = {
                              {-8},
                              {-1043},
                              {-1199},
                              {2574},
                              {9399},
                              {12993},
                              {9399},
                              {2574},
                              {-1199},
                              {-1043},
                              {-8},
                              };


// 20th Order FIR Low-pass Filter
/*
#define TAPS 21

code const SI_UU16_t B_FIR[TAPS] = {
                              {31},
                              {-392},
                              {-307},
                              {451},
                              {1016},
                              {-12},
                              {-2020},
                              {-1810},
                              {2927},
                              {9790},
                              {13090},
                              {9790},
                              {2927},
                              {-1810},
                              {-2020},
                              {-12},
                              {1016},
                              {451},
                              {-307},
                              {-392},
                              {31}
                              };
*/

//-----------------------------------------------------------------------------
// High-pass FIR Filters
//-----------------------------------------------------------------------------

// 6th Order FIR High-pass Filter
/*
#define TAPS 7

code const SI_UU16_t B_FIR[TAPS] = {
                              {632},
                              {-1714},
                              {-8824},
                              {19484},
                              {-8824},
                              {-1714},
                              {632},
                              };
*/

// 10th Order FIR High-pass Filter
/*
#define TAPS 11

code const SI_UU16_t B_FIR[TAPS] = {
                              {8},
                              {1043},
                              {1199},
                              {-2574},
                              {-9399},
                              {19775},
                              {-9399},
                              {-2574},
                              {1199},
                              {1043},
                              {8},
                              };

*/
// 20th Order FIR High-pass Filter
/*
#define TAPS 21

code const SI_UU16_t B_FIR[TAPS] = {
                              {-31},
                              {392},
                              {307},
                              {-451},
                              {-1016},
                              {12},
                              {2020},
                              {1810},
                              {-2927},
                              {-9790},
                              {19678},
                              {-9790},
                              {-2927},
                              {1810},
                              {2020},
                              {12},
                              {-1016},
                              {-451},
                              {307},
                              {392},
                              {-31}
                              };
*/

//-----------------------------------------------------------------------------
// Band-pass FIR Filters
//-----------------------------------------------------------------------------

// 5th Order FIR Band-pass Filter
/*
#define TAPS 6

code const SI_UU16_t B_FIR[TAPS] = {
                              {-2886},
                              {-3179},
                              {5901},
                              {5901},
                              {-3179},
                              {-2886},
                              };
*/

// 10th Order FIR Band-pass Filter
/*
#define TAPS 11

code const SI_UU16_t B_FIR[TAPS] = {
                              {0},
                              {2061},
                              {0},
                              {-5919},
                              {0},
                              {8043},
                              {0},
                              {-5919},
                              {0},
                              {2061},
                              {0},
                              };

*/
// 20th Order FIR Band-pass Filter
/*
#define TAPS 21

code const SI_UU16_t B_FIR[TAPS] = {
                              {-106},
                              {0},
                              {1048},
                              {0},
                              {-2425},
                              {0},
                              {4188},
                              {0},
                              {-5661},
                              {0},
                              {6239},
                              {0},
                              {-5661},
                              {0},
                              {4188},
                              {0},
                              {-2425},
                              {0},
                              {1048},
                              {0},
                              {-106}
                              };
*/

//-----------------------------------------------------------------------------
// Band-stop FIR Filters
//-----------------------------------------------------------------------------

// 6th Order FIR Band-stop Filter
/*
#define TAPS 7

code const SI_UU16_t B_FIR[TAPS] = {
                              {0},
                              {4337},
                              {0},
                              {24421},
                              {0},
                              {4337},
                              {0},
                              };
*/

// 10th Order FIR Band-stop Filter
/*
#define TAPS 11

code const SI_UU16_t B_FIR[TAPS] = {
                              {0},
                              {-2061},
                              {0},
                              {5919},
                              {0},
                              {24725},
                              {0},
                              {5919},
                              {0},
                              {-2061},
                              {0},
                              };
*/

// 20th Order FIR Band-stop Filter
/*
#define TAPS 21

code const SI_UU16_t B_FIR[TAPS] = {
                              {106},
                              {0},
                              {-1048},
                              {0},
                              {2425},
                              {0},
                              {-4188},
                              {0},
                              {5661},
                              {0},
                              {26529},
                              {0},
                              {5661},
                              {0},
                              {-4188},
                              {0},
                              {2425},
                              {0},
                              {-1048},
                              {0},
                              {106}
                              };
*/

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------