//------------------------------------------------------------------------------------
// Blinky.c
//------------------------------------------------------------------------------------
// Copyright 2001 Silicon Laboratories, Inc.
//
// AUTH: SH
// DATE: 18 MAY 05
//
// This program flashes the green LED on the C8051F124 target board 
// using the interrupt handler for Timer3.
// Target: C8051F12x
//
// Tool chain: IAR 'C' Compiler
//


//------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------
#include <ioC8051F124.h> //IAR include file

//-----------------------------------------------------------------------------
// 16-bit SFR Definitions for 'F12x
//-----------------------------------------------------------------------------
unsigned char RCAP3   = 0xCA;                 // Timer3 reload value
unsigned char TMR3     = 0xCC;                 // Timer3 counter

//------------------------------------------------------------------------------------
// Global CONSTANTS
//------------------------------------------------------------------------------------
#define SYSCLK 3062500                    // approximate SYSCLK frequency in Hz

//------------------------------------------------------------------------------------
// Function PROTOTYPES
//------------------------------------------------------------------------------------
void PORT_Init (void);
void Timer3_Init (int counts);
__interrupt void Timer3_ISR (void);

//------------------------------------------------------------------------------------
// MAIN Routine
//------------------------------------------------------------------------------------
void main (void) {
   // disable watchdog timer
   WDTCN = 0xde;
   WDTCN = 0xad;

   SFRPAGE = 0x0F;                   // Switch to configuration page
   PORT_Init ();

   SFRPAGE = 0x01;                   // Switch to Timer 3 page
   Timer3_Init (SYSCLK / 12 / 10);   // Init Timer3 to generate interrupts
			                         // at a 10 Hz rate.
   IE =  0x90;	

   SFRPAGE = 0x00;                 	 // Page to sit in for now

   while (1) {                       // spin forever
   }
}

//------------------------------------------------------------------------------------
// PORT_Init
//------------------------------------------------------------------------------------
//
// Configure the Crossbar and GPIO ports
//
void PORT_Init (void)
{
   XBR2    = 0x40;                     // Enable crossbar and weak pull-ups
   P1MDOUT |= 0x40;                    // enable P1.6 (LED) as push-pull output
}

//------------------------------------------------------------------------------------
// Timer3_Init
//------------------------------------------------------------------------------------
//
// Configure Timer3 to auto-reload and generate an interrupt at interval
// specified by <counts> using SYSCLK/12 as its time base.
//
//
void Timer3_Init (int counts)
{
   TMR3CN = 0x00;                      // Stop Timer3; Clear TF3;
                                       // use SYSCLK/12 as timebase
   RCAP3   = -counts;                  // Init reload values
   TMR3    = 0xff;                     // set to reload immediately
   EIE2   |= 0x01;                     // enable Timer3 interrupts
   TMR3CN |= 0x04;                     // start Timer3
}

//------------------------------------------------------------------------------------
// Interrupt Service Routines
//------------------------------------------------------------------------------------


//------------------------------------------------------------------------------------
// Timer3_ISR
//------------------------------------------------------------------------------------
// This routine changes the state of the LED whenever Timer3 overflows.
//
// NOTE: The SFRPAGE register will automatically be switched to the Timer 3 Page
// When an interrupt occurs.  SFRPAGE will return to its previous setting on exit
// from this routine.
#pragma vector=0x73
__interrupt void Timer3_ISR (void)
{
   TMR3CN &= ~(0x80);                   // clear TF3
   P1 = ~P1;                            // change state of LED
}


