/***************************************************************************
 *                                - ioC8051F124.h -
 *
 * Special header for the Silicon Laboratories C8051F124 Microcontroller.
 *
 ***************************************************************************/

#ifdef __IAR_SYSTEMS_ICC__
#pragma language=extended

/*-------------------------------------------------------------------------
 *   External Memory
 *-------------------------------------------------------------------------*/

__sfr __no_init volatile union
{
  unsigned char EMI0TC; /* (Page: 0) External Memory Timing Control */
  unsigned char CCH0CN; /* (Page: F) Cache Control Register */
  struct /* (Page: 0) External Memory Timing Control */
  {
    unsigned char EAS1 : 1;
    unsigned char EAS0 : 1;
    unsigned char ERW3 : 1;
    unsigned char EWR2 : 1;
    unsigned char EWR1 : 1;
    unsigned char EWR0 : 1;
    unsigned char EAH1 : 1;
    unsigned char EAH0 : 1;
  } EMI0TC_bit;
  struct /* (Page: F) Cache Control Register */
  {
    unsigned char CHWREN : 1;
    unsigned char CHRDEN : 1;
    unsigned char CHPFEN : 1;
    unsigned char CHFLSH : 1;
    unsigned char CHRETI : 1;
    unsigned char CHISR : 1;
    unsigned char CHMOVC : 1;
    unsigned char CHBLKW : 1;
  } CCH0CN_bit;
} @ 0xA1;
__sfr __no_init volatile union
{
  unsigned char EMI0CN; /* (Page: 0) External Memory Interface Control */
  unsigned char CCH0TN; /* (Page: F) Cache Tuning Register */
  struct /* (Page: 0) External Memory Interface Control */
  {
    unsigned char PGSEL7 : 1;
    unsigned char PGSEL6 : 1;
    unsigned char PGSEL5 : 1;
    unsigned char PGSEL4 : 1;
    unsigned char PGSEL3 : 1;
    unsigned char PGSEL2 : 1;
    unsigned char PGSEL1 : 1;
    unsigned char PGSEL0 : 1;
  } EMI0CN_bit;
  struct /* (Page: F) Cache Tuning Register */
  {
    unsigned char CHMSCTL3 : 1;
    unsigned char CHMSCTL2 : 1;
    unsigned char CHMSCTL1 : 1;
    unsigned char CHMSCTL0 : 1;
    unsigned char CHALGM : 1;
    unsigned char CHFIXM : 1;
    unsigned char CHMSTH1 : 1;
    unsigned char CHMSTH0 : 1;
  } CCH0TN_bit;
} @ 0xA2;
__sfr __no_init volatile union
{
  unsigned char EMI0CF; /* (Page: 0) External Memory Configuration */
  unsigned char CCH0LC; /* (Page: F) Cache Lock Control Register */
  struct /* (Page: 0) External Memory Configuration */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char PRTSEL : 1;
    unsigned char EMD2 : 1;
    unsigned char EMD1 : 1;
    unsigned char EMD0 : 1;
    unsigned char EALE1 : 1;
    unsigned char EALE0 : 1;
  } EMI0CF_bit;
  struct /* (Page: F) Cache Lock Control Register */
  {
    unsigned char FCHPUSH : 1;
    unsigned char CHPOP : 1;
    unsigned char CHSLOT5 : 1;
    unsigned char CHSLOT4 : 1;
    unsigned char CHSLOT3 : 1;
    unsigned char CHSLOT2 : 1;
    unsigned char CHSLOT1 : 1;
    unsigned char CHSLOT0 : 1;
  } CCH0LC_bit;
} @ 0xA3;

/*-------------------------------------------------------------------------
 *   ADC
 *-------------------------------------------------------------------------*/

__sfr __no_init volatile union
{
  unsigned char RSTSRC; /* (Page: 0) Reset Source Register */
  struct /* (Page: 0) Reset Source Register */
  {
    unsigned char  : 1;
    unsigned char CNVRSEF : 1;
    unsigned char C0RSEF : 1;
    unsigned char SWRSEF : 1;
    unsigned char WDTRSF : 1;
    unsigned char MCDRSF : 1;
    unsigned char PORSF : 1;
    unsigned char PINRSF : 1;
  } RSTSRC_bit;
} @ 0xEF;
__sfr __no_init volatile union
{
  unsigned char ADC0CF; /* (Page: 0) ADC0 Configuration Register */
  unsigned char ADC2CF; /* (Page: 2) ADC2 Configuration Register */
  union
  {
    struct /* (Page: 0) ADC0 Configuration Register */
    {
      unsigned char AD0SC4 : 1;
      unsigned char AD0SC3 : 1;
      unsigned char AD0SC2 : 1;
      unsigned char AD0SC1 : 1;
      unsigned char AD0SC0 : 1;
      unsigned char AMP0GN2 : 1;
      unsigned char AMP0GN1 : 1;
      unsigned char AMP0GN0 : 1;
    };
    struct /* (Page: 0) ADC0 Configuration Register */
    {
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
    };
  } ADC0CF_bit;
  struct /* (Page: 2) ADC2 Configuration Register */
  {
    unsigned char AD2SC4 : 1;
    unsigned char AD2SC3 : 1;
    unsigned char AD2SC2 : 1;
    unsigned char AD2SC1 : 1;
    unsigned char AD2SC0 : 1;
    unsigned char  : 1;
    unsigned char AMP2GN1 : 1;
    unsigned char AMP2GN0 : 1;
  } ADC2CF_bit;
} @ 0xBC;
__sfr __no_init volatile union
{
  unsigned char REF0CN; /* (Page: 0) Reference Control Register */
  union
  {
    struct /* (Page: 0) Reference Control Register */
    {
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char AD0VRS : 1;
      unsigned char AD2VRS : 1;
      unsigned char TEMPE : 1;
      unsigned char BIASE : 1;
      unsigned char REFBE : 1;
    };
    struct /* (Page: 0) Reference Control Register */
    {
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
    };
  } REF0CN_bit;
} @ 0xD1;
__sfr __no_init volatile union
{
  unsigned char ADC0L; /* (Page: 0) ADC0 Data Word LSB Register */
  unsigned char ADC2; /* (Page: 2) ADC2 Data Word Register */
  union
  {
    struct /* (Page: 0) ADC0 Data Word LSB Register */
    {
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
    };
    struct /* (Page: 0) ADC0 Data Word LSB Register */
    {
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
    };
  } ADC0L_bit;
  struct /* (Page: 2) ADC2 Data Word Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } ADC2_bit;
} @ 0xBE;
__sfr __no_init volatile union
{
  unsigned char ADC0H; /* (Page: 0) ADC0 Data Word MSB Register */
  unsigned char DC0H;
  union
  {
    struct /* (Page: 0) ADC0 Data Word MSB Register */
    {
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
    };
    struct /* (Page: 0) ADC0 Data Word MSB Register */
    {
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
    };
  } ADC0H_bit;
  struct
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } DC0H_bit;
} @ 0xBF;
__sfr __no_init volatile union
{
  unsigned char ADC0GTL; /* (Page: 0) ADC0 Greater-Than Data Low Byte Register */
  unsigned char ADC2GT; /* (Page: 2) ADC2 Greater-Than Data Byte Register */
  union
  {
    struct /* (Page: 0) ADC0 Greater-Than Data Low Byte Register */
    {
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
    };
    struct /* (Page: 0) ADC0 Greater-Than Data Low Byte Register */
    {
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
    };
  } ADC0GTL_bit;
  struct /* (Page: 2) ADC2 Greater-Than Data Byte Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } ADC2GT_bit;
} @ 0xC4;
__sfr __no_init volatile union
{
  unsigned char ADC0GTH; /* (Page: 0) ADC0 Greater-Than Data High Byte Register */
  union
  {
    struct /* (Page: 0) ADC0 Greater-Than Data High Byte Register */
    {
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
    };
    struct /* (Page: 0) ADC0 Greater-Than Data High Byte Register */
    {
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
    };
  } ADC0GTH_bit;
} @ 0xC5;
__sfr __no_init volatile union
{
  unsigned char ADC0LTL; /* (Page: 0) ADC0 Less-Than Data Low Byte Register */
  unsigned char ADC2LT; /* (Page: 2) ADC2 Less-Than Data Byte Register */
  union
  {
    struct /* (Page: 0) ADC0 Less-Than Data Low Byte Register */
    {
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
    };
    struct /* (Page: 0) ADC0 Less-Than Data Low Byte Register */
    {
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
    };
  } ADC0LTL_bit;
  struct /* (Page: 2) ADC2 Less-Than Data Byte Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } ADC2LT_bit;
} @ 0xC6;
__sfr __no_init volatile union
{
  unsigned char ADC0CN; /* (Page: 0) ADC0 Control Register */
  unsigned char ADC2CN; /* (Page: 2) ADC2 Control Register */
  unsigned char P6; /* (Page: F) Port6 Data Register */
  union
  {
    struct /* (Page: 0) ADC0 Control Register */
    {
      unsigned char AD0EN : 1;
      unsigned char AD0TM : 1;
      unsigned char AD0INT : 1;
      unsigned char AD0BUSY : 1;
      unsigned char AD0CM1 : 1;
      unsigned char AD0CM0 : 1;
      unsigned char AD0WINT : 1;
      unsigned char AD0LJST : 1;
    };
    struct /* (Page: 0) ADC0 Control Register */
    {
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
    };
  } ADC0CN_bit;
  struct /* (Page: 2) ADC2 Control Register */
  {
    unsigned char AD2EN : 1;
    unsigned char AD2TM : 1;
    unsigned char AD2INT : 1;
    unsigned char AD2BUSY : 1;
    unsigned char AD2CM2 : 1;
    unsigned char AD2CM1 : 1;
    unsigned char AD2CM0 : 1;
    unsigned char AD2WINT : 1;
  } ADC2CN_bit;
  struct /* (Page: F) Port6 Data Register */
  {
    unsigned char P67 : 1;
    unsigned char P66 : 1;
    unsigned char P65 : 1;
    unsigned char P64 : 1;
    unsigned char P63 : 1;
    unsigned char P62 : 1;
    unsigned char P61 : 1;
    unsigned char P60 : 1;
  } P6_bit;
} @ 0xE8;
__sfr __no_init volatile union
{
  unsigned char ADC0LTH; /* (Page: 0) ADC0 Less-Than Data High Byte Register */
  union
  {
    struct /* (Page: 0) ADC0 Less-Than Data High Byte Register */
    {
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
    };
    struct /* (Page: 0) ADC0 Less-Than Data High Byte Register */
    {
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
    };
  } ADC0LTH_bit;
} @ 0xC7;

/*-------------------------------------------------------------------------
 *   SPI
 *-------------------------------------------------------------------------*/

__sfr __no_init volatile union
{
  unsigned char SPI0CKR; /* (Page: 0) SPI0 Clock Rate Register */
  unsigned char P5MDOUT; /* (Page: F) Port5 Output Mode Register */
  struct /* (Page: 0) SPI0 Clock Rate Register */
  {
    unsigned char SCR7 : 1;
    unsigned char SCR6 : 1;
    unsigned char SCR5 : 1;
    unsigned char SCR4 : 1;
    unsigned char SCR3 : 1;
    unsigned char SCR2 : 1;
    unsigned char SCR1 : 1;
    unsigned char SCR0 : 1;
  } SPI0CKR_bit;
  struct /* (Page: F) Port5 Output Mode Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } P5MDOUT_bit;
} @ 0x9D;
__sfr __no_init volatile union
{
  unsigned char SPI0CN; /* (Page: 0) SPI0 Control Register */
  unsigned char P7; /* (Page: F) Port7 Data Register */
  struct /* (Page: 0) SPI0 Control Register */
  {
    unsigned char SPIF : 1;
    unsigned char WCOL : 1;
    unsigned char MODF : 1;
    unsigned char RXOVRN : 1;
    unsigned char NSSMD1 : 1;
    unsigned char NSSMD0 : 1;
    unsigned char TXBMT : 1;
    unsigned char SPIEN : 1;
  } SPI0CN_bit;
  struct /* (Page: F) Port7 Data Register */
  {
    unsigned char P77 : 1;
    unsigned char P76 : 1;
    unsigned char P75 : 1;
    unsigned char P74 : 1;
    unsigned char P73 : 1;
    unsigned char P72 : 1;
    unsigned char P71 : 1;
    unsigned char P70 : 1;
  } P7_bit;
} @ 0xF8;
__sfr __no_init volatile union
{
  unsigned char SPI0CFG; /* (Page: 0) SPI0 Configuration Register */
  unsigned char CCH0MA; /* (Page: F) Cache Miss Accumulator */
  struct /* (Page: 0) SPI0 Configuration Register */
  {
    unsigned char SPIBSY : 1;
    unsigned char MSTEN : 1;
    unsigned char CKPHA : 1;
    unsigned char CKPOL : 1;
    unsigned char SLVSEL : 1;
    unsigned char NSSIN : 1;
    unsigned char SRMT : 1;
    unsigned char RXBMT : 1;
  } SPI0CFG_bit;
  struct /* (Page: F) Cache Miss Accumulator */
  {
    unsigned char CHMSOV : 1;
    unsigned char CHMSCTH6 : 1;
    unsigned char CHMSCTH5 : 1;
    unsigned char CHMSCTH4 : 1;
    unsigned char CHMSCTH3 : 1;
    unsigned char CHMSCTH2 : 1;
    unsigned char CHMSCTH1 : 1;
    unsigned char CHMSCTH0 : 1;
  } CCH0MA_bit;
} @ 0x9A;
__sfr __no_init volatile unsigned char SPI0DAT @ 0x9B; /* (Page: 0) SPI0 Data Register */

/*-------------------------------------------------------------------------
 *   MCS-51 Core
 *-------------------------------------------------------------------------*/

__sfr __no_init volatile union
{
  unsigned char ACC; /* (All Pages) Accumulator */
  struct /* (All Pages) Accumulator */
  {
    unsigned char ACC7 : 1;
    unsigned char ACC6 : 1;
    unsigned char ACC5 : 1;
    unsigned char ACC4 : 1;
    unsigned char ACC3 : 1;
    unsigned char ACC2 : 1;
    unsigned char ACC1 : 1;
    unsigned char ACC0 : 1;
  } ACC_bit;
} @ 0xE0;
__sfr __no_init volatile union
{
  unsigned char PSW; /* (All Pages) Program Status Word */
  struct /* (All Pages) Program Status Word */
  {
    unsigned char CY : 1;
    unsigned char AC : 1;
    unsigned char F0 : 1;
    unsigned char RS1 : 1;
    unsigned char RS0 : 1;
    unsigned char OV : 1;
    unsigned char F1 : 1;
    unsigned char PARITY : 1;
  } PSW_bit;
} @ 0xD0;
__sfr __no_init volatile unsigned char SP @ 0x81; /* (All Pages) Stack Pointer */
__sfr __no_init volatile unsigned char DPL @ 0x82; /* (All Pages) Data Pointer Low Byte */
__sfr __no_init volatile unsigned char DPH @ 0x83; /* (All Pages) Data Pointer High Byte */
__sfr __no_init volatile union
{
  unsigned char B; /* (All Pages) B Register */
  struct /* (All Pages) B Register */
  {
    unsigned char B7 : 1;
    unsigned char B6 : 1;
    unsigned char B5 : 1;
    unsigned char B4 : 1;
    unsigned char B3 : 1;
    unsigned char B2 : 1;
    unsigned char B1 : 1;
    unsigned char B0 : 1;
  } B_bit;
} @ 0xF0;

/*-------------------------------------------------------------------------
 *   PCA
 *-------------------------------------------------------------------------*/

__sfr __no_init volatile union
{
  unsigned char PCA0CPM3; /* (Page: 0) PCA0 Capture/Compare Mode Registers 3 */
  struct /* (Page: 0) PCA0 Capture/Compare Mode Registers 3 */
  {
    unsigned char PWM163 : 1;
    unsigned char ECOM3 : 1;
    unsigned char CAPP3 : 1;
    unsigned char CAPN3 : 1;
    unsigned char MAT3 : 1;
    unsigned char TOG3 : 1;
    unsigned char PWM3 : 1;
    unsigned char ECCF3 : 1;
  } PCA0CPM3_bit;
} @ 0xDD;
__sfr __no_init volatile unsigned char PCA0CPH4 @ 0xEE; /* (Page: 0) PCA0 Capture Module High Byte 4 */
__sfr __no_init volatile union
{
  unsigned char PCA0CPM4; /* (Page: 0) PCA0 Capture/Compare Mode Registers 4 */
  struct /* (Page: 0) PCA0 Capture/Compare Mode Registers 4 */
  {
    unsigned char PWM164 : 1;
    unsigned char ECOM4 : 1;
    unsigned char CAPP4 : 1;
    unsigned char CAPN4 : 1;
    unsigned char MAT4 : 1;
    unsigned char TOG4 : 1;
    unsigned char PWM4 : 1;
    unsigned char ECCF4 : 1;
  } PCA0CPM4_bit;
} @ 0xDE;
__sfr __no_init volatile union
{
  unsigned char PCA0CPL5; /* (Page: 0) PCA0 Capture Module Low Byte 5 */
  unsigned char XBR0; /* (Page: F) Port I/O Crossbar Register 0 */
  struct /* (Page: 0) PCA0 Capture Module Low Byte 5 */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } PCA0CPL5_bit;
  struct /* (Page: F) Port I/O Crossbar Register 0 */
  {
    unsigned char CP0E : 1;
    unsigned char ECI0E : 1;
    unsigned char PCA0ME2 : 1;
    unsigned char PCA0ME1 : 1;
    unsigned char PCA0ME0 : 1;
    unsigned char UART0EN : 1;
    unsigned char SPI0EN : 1;
    unsigned char SMB0EN : 1;
  } XBR0_bit;
} @ 0xE1;
__sfr __no_init volatile union
{
  unsigned char PCA0CPM5; /* (Page: 0) PCA0 Capture/Compare Mode Registers 5 */
  struct /* (Page: 0) PCA0 Capture/Compare Mode Registers 5 */
  {
    unsigned char PWM165 : 1;
    unsigned char ECOM5 : 1;
    unsigned char CAPP5 : 1;
    unsigned char CAPN5 : 1;
    unsigned char MAT5 : 1;
    unsigned char TOG5 : 1;
    unsigned char PWM5 : 1;
    unsigned char ECCF5 : 1;
  } PCA0CPM5_bit;
} @ 0xDF;
__sfr __no_init volatile union
{
  unsigned char PCA0CPH5; /* (Page: 0) PCA0 Capture Module High Byte 5 */
  unsigned char XBR1; /* (Page: F) Port I/O Crossbar Register 1 */
  struct /* (Page: 0) PCA0 Capture Module High Byte 5 */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } PCA0CPH5_bit;
  struct /* (Page: F) Port I/O Crossbar Register 1 */
  {
    unsigned char SYSCKE : 1;
    unsigned char T2EXE : 1;
    unsigned char T2E : 1;
    unsigned char INT1E : 1;
    unsigned char T1E : 1;
    unsigned char INT0E : 1;
    unsigned char T0E : 1;
    unsigned char CP1E : 1;
  } XBR1_bit;
} @ 0xE2;
__sfr __no_init volatile unsigned char PCA0H @ 0xFA; /* (Page: 0) PCA0 Counter/Timer High Byte */
__sfr __no_init volatile unsigned char PCA0CPL0 @ 0xFB; /* (Page: 0) PCA0 Capture Module Low Byte 0 */
__sfr __no_init volatile unsigned char PCA0CPH2 @ 0xEA; /* (Page: 0) PCA0 Capture Module High Byte 2 */
__sfr __no_init volatile union
{
  unsigned char PCA0CPM0; /* (Page: 0) PCA0 Capture/Compare Mode Registers 0 */
  struct /* (Page: 0) PCA0 Capture/Compare Mode Registers 0 */
  {
    unsigned char PWM160 : 1;
    unsigned char ECOM0 : 1;
    unsigned char CAPP0 : 1;
    unsigned char CAPN0 : 1;
    unsigned char MAT0 : 1;
    unsigned char TOG0 : 1;
    unsigned char PWM0 : 1;
    unsigned char ECCF0 : 1;
  } PCA0CPM0_bit;
} @ 0xDA;
__sfr __no_init volatile unsigned char PCA0CPL3 @ 0xEB; /* (Page: 0) PCA0 Capture Module Low Byte 3 */
__sfr __no_init volatile unsigned char PCA0CPH0 @ 0xFC; /* (Page: 0) PCA0 Capture Module High Byte 0 */
__sfr __no_init volatile unsigned char PCA0L @ 0xF9; /* (Page: 0) PCA0 Counter/Timer Low Byte */
__sfr __no_init volatile union
{
  unsigned char PCA0CPM1; /* (Page: 0) PCA0 Capture/Compare Mode Registers 1 */
  struct /* (Page: 0) PCA0 Capture/Compare Mode Registers 1 */
  {
    unsigned char PWM161 : 1;
    unsigned char ECOM1 : 1;
    unsigned char CAPP1 : 1;
    unsigned char CAPN1 : 1;
    unsigned char MAT1 : 1;
    unsigned char TOG1 : 1;
    unsigned char PWM1 : 1;
    unsigned char ECCF1 : 1;
  } PCA0CPM1_bit;
} @ 0xDB;
__sfr __no_init volatile unsigned char PCA0CPH3 @ 0xEC; /* (Page: 0) PCA0 Capture Module High Byte 3 */
__sfr __no_init volatile union
{
  unsigned char PCA0CPH1; /* (Page: 0) PCA0 Capture Module High Byte 1 */
  unsigned char PCA0CPL1; /* (Page: 0) PCA0 Capture Module Low Byte 1 */
  struct /* (Page: 0) PCA0 Capture Module High Byte 1 */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } PCA0CPH1_bit;
  struct /* (Page: 0) PCA0 Capture Module Low Byte 1 */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } PCA0CPL1_bit;
} @ 0xFD;
__sfr __no_init volatile union
{
  unsigned char PCA0CPM2; /* (Page: 0) PCA0 Capture/Compare Mode Registers 2 */
  struct /* (Page: 0) PCA0 Capture/Compare Mode Registers 2 */
  {
    unsigned char PWM162 : 1;
    unsigned char ECOM2 : 1;
    unsigned char CAPP2 : 1;
    unsigned char CAPN2 : 1;
    unsigned char MAT2 : 1;
    unsigned char TOG2 : 1;
    unsigned char PWM2 : 1;
    unsigned char ECCF2 : 1;
  } PCA0CPM2_bit;
} @ 0xDC;
__sfr __no_init volatile unsigned char PCA0CPL4 @ 0xED; /* (Page: 0) PCA0 Capture Module Low Byte 4 */
__sfr __no_init volatile unsigned char PCA0CPL2 @ 0xE9; /* (Page: 0) PCA0 Capture Module Low Byte 2 */
__sfr __no_init volatile union
{
  unsigned char PCA0CN; /* (Page: 0) PCA Control Register */
  unsigned char P5; /* (Page: F) Port5 Data Register */
  union
  {
    struct /* (Page: 0) PCA Control Register */
    {
      unsigned char CCF7 : 1;
      unsigned char CCF6 : 1;
      unsigned char CCF5 : 1;
      unsigned char CCF4 : 1;
      unsigned char CCF3 : 1;
      unsigned char CCF2 : 1;
      unsigned char CCF1 : 1;
      unsigned char CCF0 : 1;
    };
    struct /* (Page: 0) PCA Control Register */
    {
      unsigned char CF : 1;
      unsigned char CR : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
    };
  } PCA0CN_bit;
  struct /* (Page: F) Port5 Data Register */
  {
    unsigned char P57 : 1;
    unsigned char P56 : 1;
    unsigned char P55 : 1;
    unsigned char P54 : 1;
    unsigned char P53 : 1;
    unsigned char P52 : 1;
    unsigned char P51 : 1;
    unsigned char P50 : 1;
  } P5_bit;
} @ 0xD8;
__sfr __no_init volatile union
{
  unsigned char PCA0MD; /* (Page: 0) PCA0 Mode Register */
  struct /* (Page: 0) PCA0 Mode Register */
  {
    unsigned char CIDL : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char CPS2 : 1;
    unsigned char CPS1 : 1;
    unsigned char CPS0 : 1;
    unsigned char ECF : 1;
  } PCA0MD_bit;
} @ 0xD9;

/*-------------------------------------------------------------------------
 *   Interrupt
 *-------------------------------------------------------------------------*/

__sfr __no_init volatile union
{
  unsigned char IP; /* (All Pages) Interrupt Priority */
  struct /* (All Pages) Interrupt Priority */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char PT2 : 1;
    unsigned char PS0 : 1;
    unsigned char PT1 : 1;
    unsigned char PX1 : 1;
    unsigned char PT0 : 1;
    unsigned char PX0 : 1;
  } IP_bit;
} @ 0xB8;
__sfr __no_init volatile union
{
  unsigned char IE; /* (All Pages) Interrupt Enable */
  struct /* (All Pages) Interrupt Enable */
  {
    unsigned char EA : 1;
    unsigned char IEGF0 : 1;
    unsigned char ET2 : 1;
    unsigned char ES0 : 1;
    unsigned char ET1 : 1;
    unsigned char EX1 : 1;
    unsigned char ET0 : 1;
    unsigned char EX0 : 1;
  } IE_bit;
} @ 0xA8;
__sfr __no_init volatile union
{
  unsigned char EIP1; /* (All Pages) Extended Interrupt Priority 1 */
  struct /* (All Pages) Extended Interrupt Priority 1 */
  {
    unsigned char PCP1R : 1;
    unsigned char PCP1F : 1;
    unsigned char PCP0R : 1;
    unsigned char PCP0F : 1;
    unsigned char PPCA0 : 1;
    unsigned char PWADC0 : 1;
    unsigned char PSMB0 : 1;
    unsigned char PSPI0 : 1;
  } EIP1_bit;
} @ 0xF6;
__sfr __no_init volatile union
{
  unsigned char EIP2; /* (All Pages) Extended Interrupt Priority 2 */
  struct /* (All Pages) Extended Interrupt Priority 2 */
  {
    unsigned char  : 1;
    unsigned char PS1 : 1;
    unsigned char  : 1;
    unsigned char PADC2 : 1;
    unsigned char PWADC2 : 1;
    unsigned char PT4 : 1;
    unsigned char PADC0 : 1;
    unsigned char PT3 : 1;
  } EIP2_bit;
} @ 0xF7;
__sfr __no_init volatile union
{
  unsigned char EIE1; /* (All Pages) Extended Interrupt Enable 1 */
  struct /* (All Pages) Extended Interrupt Enable 1 */
  {
    unsigned char ECP1R : 1;
    unsigned char ECP1F : 1;
    unsigned char ECP0R : 1;
    unsigned char ECP0F : 1;
    unsigned char EPCA0 : 1;
    unsigned char EWADC0 : 1;
    unsigned char ESMB0 : 1;
    unsigned char ESPI0 : 1;
  } EIE1_bit;
} @ 0xE6;
__sfr __no_init volatile union
{
  unsigned char EIE2; /* (All Pages) Extended Interrupt Enable 2 */
  struct /* (All Pages) Extended Interrupt Enable 2 */
  {
    unsigned char  : 1;
    unsigned char ES1 : 1;
    unsigned char  : 1;
    unsigned char EADC2 : 1;
    unsigned char EWADC2 : 1;
    unsigned char ET4 : 1;
    unsigned char EADC0 : 1;
    unsigned char ET3 : 1;
  } EIE2_bit;
} @ 0xE7;

/*-------------------------------------------------------------------------
 *   MAC
 *-------------------------------------------------------------------------*/

__sfr __no_init volatile union
{
  unsigned char MAC0STA; /* (Page: 3) MAC0 Status Register */
  unsigned char SMB0CN; /* (Page: 0) SMBus0 Control Register */
  struct /* (Page: 3) MAC0 Status Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char MAC0HO : 1;
    unsigned char MAC0Z : 1;
    unsigned char MAC0SO : 1;
    unsigned char MAC0N : 1;
  } MAC0STA_bit;
  struct /* (Page: 0) SMBus0 Control Register */
  {
    unsigned char BUSY : 1;
    unsigned char ENSMB : 1;
    unsigned char STA : 1;
    unsigned char STO : 1;
    unsigned char SI : 1;
    unsigned char AA : 1;
    unsigned char FTE : 1;
    unsigned char TOE : 1;
  } SMB0CN_bit;
} @ 0xC0;
__sfr __no_init volatile unsigned char MAC0RNDL @ 0xCE; /* (Page: 3) MAC0 Rounding Register Low Byte */
__sfr __no_init volatile union
{
  unsigned char MAC0BL; /* (Page: 3) MAC0 B Low Byte Register */
  unsigned char SSTA0; /* (Page: 0) UART0 Status and Clock Selection Register */
  struct /* (Page: 3) MAC0 B Low Byte Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } MAC0BL_bit;
  struct /* (Page: 0) UART0 Status and Clock Selection Register */
  {
    unsigned char FE0 : 1;
    unsigned char RXOV0 : 1;
    unsigned char TXCOL0 : 1;
    unsigned char SMOD0 : 1;
    unsigned char S0TCLK1 : 1;
    unsigned char S0TCLK0 : 1;
    unsigned char S0RCLK1 : 1;
    unsigned char S0RCLK0 : 1;
  } SSTA0_bit;
} @ 0x91;
__sfr __no_init volatile union
{
  unsigned char MAC0RNDH; /* (Page: 3) MAC0 Rounding Register High Byte */
  unsigned char SMB0CR; /* (Page: 0) SMBus0 Clock Rate Register */
  struct /* (Page: 3) MAC0 Rounding Register High Byte */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } MAC0RNDH_bit;
  struct /* (Page: 0) SMBus0 Clock Rate Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } SMB0CR_bit;
} @ 0xCF;
__sfr __no_init volatile unsigned char MAC0BH @ 0x92; /* (Page: 3) MAC0 B High Byte Register */
__sfr __no_init volatile union
{
  unsigned char MAC0AL; /* (Page: 3) MAC0 A Low Byte Register */
  unsigned char SMB0STA; /* (Page: 0) SMBus0 Status Register */
  struct /* (Page: 3) MAC0 A Low Byte Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } MAC0AL_bit;
  struct /* (Page: 0) SMBus0 Status Register */
  {
    unsigned char STA7 : 1;
    unsigned char STA6 : 1;
    unsigned char STA5 : 1;
    unsigned char STA4 : 1;
    unsigned char STA3 : 1;
    unsigned char STA2 : 1;
    unsigned char STA1 : 1;
    unsigned char STA0 : 1;
  } SMB0STA_bit;
} @ 0xC1;
__sfr __no_init volatile union
{
  unsigned char MAC0AH; /* (Page: 3) MAC0 A High Byte Register */
  unsigned char SMB0DAT; /* (Page: 0) SMBus0 Data Register */
  struct /* (Page: 3) MAC0 A High Byte Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } MAC0AH_bit;
  struct /* (Page: 0) SMBus0 Data Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } SMB0DAT_bit;
} @ 0xC2;
__sfr __no_init volatile unsigned char MAC0ACC0 @ 0x93; /* (Page: 3) MAC0 Accumulator Byte 0 Register */
__sfr __no_init volatile union
{
  unsigned char MAC0CF; /* (Page: 3) MAC0 Configuration Register */
  unsigned char SMB0ADR; /* (Page: 0) SMBus0 Address Register */
  struct /* (Page: 3) MAC0 Configuration Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char MAC0SC : 1;
    unsigned char MAC0SD : 1;
    unsigned char MAC0CA : 1;
    unsigned char MAC0SAT : 1;
    unsigned char MAC0FM : 1;
    unsigned char MAC0MS : 1;
  } MAC0CF_bit;
  struct /* (Page: 0) SMBus0 Address Register */
  {
    unsigned char SLV6 : 1;
    unsigned char SLV5 : 1;
    unsigned char SLV4 : 1;
    unsigned char SLV3 : 1;
    unsigned char SLV2 : 1;
    unsigned char SLV1 : 1;
    unsigned char SLV0 : 1;
    unsigned char GC : 1;
  } SMB0ADR_bit;
} @ 0xC3;
__sfr __no_init volatile unsigned char MAC0ACC1 @ 0x94; /* (Page: 3) MAC0 Accumulator Byte 1 Register */
__sfr __no_init volatile unsigned char MAC0ACC2 @ 0x95; /* (Page: 3) MAC0 Accumulator Byte 2 Register */
__sfr __no_init volatile union
{
  unsigned char MAC0ACC3; /* (Page: 3) MAC0 Accumulator Byte 3 Register */
  unsigned char SFRPGCN; /* (Page: F) SFR Page Control Register */
  struct /* (Page: 3) MAC0 Accumulator Byte 3 Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } MAC0ACC3_bit;
  struct /* (Page: F) SFR Page Control Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char SFRPGEN : 1;
  } SFRPGCN_bit;
} @ 0x96;
__sfr __no_init volatile union
{
  unsigned char MAC0OVR; /* (Page: 3) MAC0 Accumulator Overflow Register */
  unsigned char CLKSEL; /* (Page: F) System Clock Selection Register */
  struct /* (Page: 3) MAC0 Accumulator Overflow Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } MAC0OVR_bit;
  struct /* (Page: F) System Clock Selection Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char CLKDIV1 : 1;
    unsigned char CLKDIV0 : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char CLKSL1 : 1;
    unsigned char CLKSL0 : 1;
  } CLKSEL_bit;
} @ 0x97;

/*-------------------------------------------------------------------------
 *   Comparator
 *-------------------------------------------------------------------------*/

__sfr __no_init volatile union
{
  unsigned char CPT0CN; /* (Page: 1) Comparator0 Control Register */
  unsigned char CPT1CN; /* (Page: 2) Comparator1 Control Register */
  unsigned char FLSTAT; /* (Page: F) FLASH Status */
  unsigned char TCON; /* (Page: 0) Timer Control Register */
  struct /* (Page: 1) Comparator0 Control Register */
  {
    unsigned char CP0EN : 1;
    unsigned char CP0OUT : 1;
    unsigned char CP0RIF : 1;
    unsigned char CP0FIF : 1;
    unsigned char CP0HYP1 : 1;
    unsigned char CP0HYP0 : 1;
    unsigned char CP0HYN1 : 1;
    unsigned char CP0HYN0 : 1;
  } CPT0CN_bit;
  struct /* (Page: 2) Comparator1 Control Register */
  {
    unsigned char CP1EN : 1;
    unsigned char CP1OUT : 1;
    unsigned char CP1RIF : 1;
    unsigned char CP1FIF : 1;
    unsigned char CP1HYP1 : 1;
    unsigned char CP1HYP0 : 1;
    unsigned char CP1HYN1 : 1;
    unsigned char CP1HYN0 : 1;
  } CPT1CN_bit;
  struct /* (Page: F) FLASH Status */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char FLBUSY : 1;
  } FLSTAT_bit;
  struct /* (Page: 0) Timer Control Register */
  {
    unsigned char TF1 : 1;
    unsigned char TR1 : 1;
    unsigned char TF0 : 1;
    unsigned char TR0 : 1;
    unsigned char IE1 : 1;
    unsigned char IT1 : 1;
    unsigned char IE0 : 1;
    unsigned char IT0 : 1;
  } TCON_bit;
} @ 0x88;
__sfr __no_init volatile union
{
  unsigned char CPT0MD; /* (Page: 1) Comparator0 Mode Selection Register */
  unsigned char CPT1MD; /* (Page: 2) Comparator1 Mode Selection Register */
  unsigned char PLL0CN; /* (Page: F) PLL Control Register */
  unsigned char TMOD; /* (Page: 0) Timer Mode Register */
  struct /* (Page: 1) Comparator0 Mode Selection Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char CP0RIE : 1;
    unsigned char CP0FIE : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char CP0MD1 : 1;
    unsigned char CP0MD0 : 1;
  } CPT0MD_bit;
  struct /* (Page: 2) Comparator1 Mode Selection Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char CP1RIE : 1;
    unsigned char CP1FIE : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char CP1MD1 : 1;
    unsigned char CP1MD0 : 1;
  } CPT1MD_bit;
  struct /* (Page: F) PLL Control Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char PLLLCK : 1;
    unsigned char  : 1;
    unsigned char PLLSRC : 1;
    unsigned char PLLEN : 1;
    unsigned char PLLPWR : 1;
  } PLL0CN_bit;
  struct /* (Page: 0) Timer Mode Register */
  {
    unsigned char GATE1 : 1;
    unsigned char C_T1 : 1;
    unsigned char T1M1 : 1;
    unsigned char T1M0 : 1;
    unsigned char GATE0 : 1;
    unsigned char C_T0 : 1;
    unsigned char T0M1 : 1;
    unsigned char T0M0 : 1;
  } TMOD_bit;
} @ 0x89;

/*-------------------------------------------------------------------------
 *   I/O Port
 *-------------------------------------------------------------------------*/

__sfr __no_init volatile unsigned char P3MDOUT @ 0xA7; /* (Page: F) Port3 Output Mode Register */
__sfr __no_init volatile unsigned char P6MDOUT @ 0x9E; /* (Page: F) Port6 Output Mode Register */
__sfr __no_init volatile union
{
  unsigned char P1; /* (All Pages) Port1 Data Register */
  struct /* (All Pages) Port1 Data Register */
  {
    unsigned char P17 : 1;
    unsigned char P16 : 1;
    unsigned char P15 : 1;
    unsigned char P14 : 1;
    unsigned char P13 : 1;
    unsigned char P12 : 1;
    unsigned char P11 : 1;
    unsigned char P10 : 1;
  } P1_bit;
} @ 0x90;
__sfr __no_init volatile unsigned char P7MDOUT @ 0x9F; /* (Page: F) Port7 Output Mode Register */
__sfr __no_init volatile union
{
  unsigned char P0; /* (All Pages) Port0 Data Register */
  struct /* (All Pages) Port0 Data Register */
  {
    unsigned char P07 : 1;
    unsigned char P06 : 1;
    unsigned char P05 : 1;
    unsigned char P04 : 1;
    unsigned char P03 : 1;
    unsigned char P02 : 1;
    unsigned char P01 : 1;
    unsigned char P00 : 1;
  } P0_bit;
} @ 0x80;
__sfr __no_init volatile union
{
  unsigned char XBR2; /* (Page: F) Port I/O Crossbar Register 2 */
  struct /* (Page: F) Port I/O Crossbar Register 2 */
  {
    unsigned char WEAKPUD : 1;
    unsigned char XBARE : 1;
    unsigned char CNVST2E : 1;
    unsigned char T4EXE : 1;
    unsigned char T4E : 1;
    unsigned char UART1E : 1;
    unsigned char EMIFLE : 1;
    unsigned char CNVST0E : 1;
  } XBR2_bit;
} @ 0xE3;
__sfr __no_init volatile union
{
  unsigned char P3; /* (All Pages) Port3 Data Register */
  struct /* (All Pages) Port3 Data Register */
  {
    unsigned char P37 : 1;
    unsigned char P36 : 1;
    unsigned char P35 : 1;
    unsigned char P34 : 1;
    unsigned char P33 : 1;
    unsigned char P32 : 1;
    unsigned char P31 : 1;
    unsigned char P30 : 1;
  } P3_bit;
} @ 0xB0;
__sfr __no_init volatile unsigned char P1MDIN @ 0xAD; /* (Page: F) Port1 Input Mode Register */
__sfr __no_init volatile union
{
  unsigned char P2; /* (All Pages) Port2 Data Register */
  struct /* (All Pages) Port2 Data Register */
  {
    unsigned char P27 : 1;
    unsigned char P26 : 1;
    unsigned char P25 : 1;
    unsigned char P24 : 1;
    unsigned char P23 : 1;
    unsigned char P22 : 1;
    unsigned char P21 : 1;
    unsigned char P20 : 1;
  } P2_bit;
} @ 0xA0;
__sfr __no_init volatile unsigned char P0MDOUT @ 0xA4; /* (Page: F) Port0 Output Mode Register */
__sfr __no_init volatile unsigned char P1MDOUT @ 0xA5; /* (Page: F) Port1 Output Mode Register */
__sfr __no_init volatile unsigned char P4MDOUT @ 0x9C; /* (Page: F) Port4 Output Mode Register */
__sfr __no_init volatile union
{
  unsigned char P4; /* (Page: F) Port4 Data Register */
  unsigned char TMR2CN; /* (Page: 0) Timer 2 Control Registers */
  unsigned char TMR3CN; /* (Page: 1) Timer 3 Control Registers */
  unsigned char TMR4CN; /* (Page: 2) Timer 4 Control Registers */
  struct /* (Page: F) Port4 Data Register */
  {
    unsigned char P47 : 1;
    unsigned char P46 : 1;
    unsigned char P45 : 1;
    unsigned char P44 : 1;
    unsigned char P43 : 1;
    unsigned char P42 : 1;
    unsigned char P41 : 1;
    unsigned char P40 : 1;
  } P4_bit;
  struct /* (Page: 0) Timer 2 Control Registers */
  {
    unsigned char TF2 : 1;
    unsigned char EXF2 : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char EXEN2 : 1;
    unsigned char TR2 : 1;
    unsigned char C_T2 : 1;
    unsigned char CP_RL2 : 1;
  } TMR2CN_bit;
  struct /* (Page: 1) Timer 3 Control Registers */
  {
    unsigned char TF3 : 1;
    unsigned char EXF3 : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char EXEN3 : 1;
    unsigned char TR3 : 1;
    unsigned char C_T3 : 1;
    unsigned char CP_RL3 : 1;
  } TMR3CN_bit;
  struct /* (Page: 2) Timer 4 Control Registers */
  {
    unsigned char TF4 : 1;
    unsigned char EXF4 : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char EXEN4 : 1;
    unsigned char TR4 : 1;
    unsigned char C_T4 : 1;
    unsigned char CP_RL4 : 1;
  } TMR4CN_bit;
} @ 0xC8;
__sfr __no_init volatile unsigned char P2MDOUT @ 0xA6; /* (Page: F) Port2 Output Mode Register */

/*-------------------------------------------------------------------------
 *   Flash Memory
 *-------------------------------------------------------------------------*/

__sfr __no_init volatile union
{
  unsigned char FLACL; /* (Page: F) FLASH Access Limit */
  unsigned char FLSCL; /* (Page: 0) FLASH Memory Control */
  struct /* (Page: F) FLASH Access Limit */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } FLACL_bit;
  struct /* (Page: 0) FLASH Memory Control */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char FLRT1 : 1;
    unsigned char FLRT0 : 1;
    unsigned char Reserved0 : 1;
    unsigned char Reserved1 : 1;
    unsigned char Reserved2 : 1;
    unsigned char FLWE : 1;
  } FLSCL_bit;
} @ 0xB7;

/*-------------------------------------------------------------------------
 *   DAC
 *-------------------------------------------------------------------------*/

__sfr __no_init volatile union
{
  unsigned char DAC0L; /* (Page: 0) DAC0 Low Byte Register */
  unsigned char DAC1L; /* (Page: 1) DAC1 Low Byte Register */
  struct /* (Page: 0) DAC0 Low Byte Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } DAC0L_bit;
  struct /* (Page: 1) DAC1 Low Byte Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } DAC1L_bit;
} @ 0xD2;
__sfr __no_init volatile union
{
  unsigned char DAC0H; /* (Page: 0) DAC0 High Byte Register */
  unsigned char DAC1H; /* (Page: 1) DAC1 High Byte Register */
  struct /* (Page: 0) DAC0 High Byte Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } DAC0H_bit;
  struct /* (Page: 1) DAC1 High Byte Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } DAC1H_bit;
} @ 0xD3;
__sfr __no_init volatile union
{
  unsigned char DAC0CN; /* (Page: 0) DAC0 Control Register */
  unsigned char DAC1CN; /* (Page: 1) DAC1 Control Register */
  struct /* (Page: 0) DAC0 Control Register */
  {
    unsigned char DAC0EN : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char DAC0MD1 : 1;
    unsigned char DAC0MD0 : 1;
    unsigned char DAC0DF2 : 1;
    unsigned char DAC0DF1 : 1;
    unsigned char DAC0DF0 : 1;
  } DAC0CN_bit;
  struct /* (Page: 1) DAC1 Control Register */
  {
    unsigned char DAC1EN : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char DAC1MD1 : 1;
    unsigned char DAC1MD0 : 1;
    unsigned char DAC1DF2 : 1;
    unsigned char DAC1DF1 : 1;
    unsigned char DAC1DF0 : 1;
  } DAC1CN_bit;
} @ 0xD4;

/*-------------------------------------------------------------------------
 *   WDT
 *-------------------------------------------------------------------------*/

__sfr __no_init volatile unsigned char WDTCN @ 0xFF; /* (All Pages) Watchdog Timer Control Register */

/*-------------------------------------------------------------------------
 *   Serial I/O
 *-------------------------------------------------------------------------*/

__sfr __no_init volatile union
{
  unsigned char SBUF0; /* (Page: 0) UART0 Data Buffer Register */
  unsigned char SBUF1; /* (Page: 1) Serial (UART1) Port Data Buffer Register */
  struct /* (Page: 0) UART0 Data Buffer Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } SBUF0_bit;
  struct /* (Page: 1) Serial (UART1) Port Data Buffer Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } SBUF1_bit;
} @ 0x99;
__sfr __no_init volatile unsigned char SADEN0 @ 0xB9; /* (Page: 0) UART0 Slave Address Enable Register */
__sfr __no_init volatile unsigned char SADDR0 @ 0xA9; /* (Page: 0) UART0 Slave Address Register */
__sfr __no_init volatile union
{
  unsigned char SCON0; /* (Page: 0) UART0 Control Register */
  unsigned char SCON1; /* (Page: 1) Serial Port 1 Control Register */
  struct /* (Page: 0) UART0 Control Register */
  {
    unsigned char SM00 : 1;
    unsigned char SM10 : 1;
    unsigned char SM20 : 1;
    unsigned char REN0 : 1;
    unsigned char TB80 : 1;
    unsigned char RB80 : 1;
    unsigned char TI0 : 1;
    unsigned char RI0 : 1;
  } SCON0_bit;
  struct /* (Page: 1) Serial Port 1 Control Register */
  {
    unsigned char S1MODE : 1;
    unsigned char  : 1;
    unsigned char MCE1 : 1;
    unsigned char REN1 : 1;
    unsigned char TB81 : 1;
    unsigned char RB81 : 1;
    unsigned char TI1 : 1;
    unsigned char RI1 : 1;
  } SCON1_bit;
} @ 0x98;

/*-------------------------------------------------------------------------
 *   System Administration
 *-------------------------------------------------------------------------*/

__sfr __no_init volatile union
{
  unsigned char OSCXCN; /* (Page: F) External Oscillator Control Register */
  unsigned char TH0; /* (Page: 0) Timer 0 High Byte */
  struct /* (Page: F) External Oscillator Control Register */
  {
    unsigned char XTLVLD : 1;
    unsigned char XOSCMD2 : 1;
    unsigned char XOSCMD1 : 1;
    unsigned char XOSCMD0 : 1;
    unsigned char  : 1;
    unsigned char XFCN2 : 1;
    unsigned char XFCN1 : 1;
    unsigned char XFCN0 : 1;
  } OSCXCN_bit;
  struct /* (Page: 0) Timer 0 High Byte */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } TH0_bit;
} @ 0x8C;
__sfr __no_init volatile union
{
  unsigned char PLL0DIV; /* (Page: F) PLL Pre-divider Register */
  unsigned char TH1; /* (Page: 0) Timer 1 High Byte */
  struct /* (Page: F) PLL Pre-divider Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char PLLM4 : 1;
    unsigned char PLLM3 : 1;
    unsigned char PLLM2 : 1;
    unsigned char PLLM1 : 1;
    unsigned char PLLM0 : 1;
  } PLL0DIV_bit;
  struct /* (Page: 0) Timer 1 High Byte */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } TH1_bit;
} @ 0x8D;
__sfr __no_init volatile union
{
  unsigned char PLL0MUL; /* (Page: F) PLL Clock Scaler Register */
  unsigned char CKCON; /* (Page: 0) Clock Control Register */
  struct /* (Page: F) PLL Clock Scaler Register */
  {
    unsigned char PLLN7 : 1;
    unsigned char PLLN6 : 1;
    unsigned char PLLN5 : 1;
    unsigned char PLLN4 : 1;
    unsigned char PLLN3 : 1;
    unsigned char PLLN2 : 1;
    unsigned char PLLN1 : 1;
    unsigned char PLLN0 : 1;
  } PLL0MUL_bit;
  struct /* (Page: 0) Clock Control Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char T1M : 1;
    unsigned char T0M : 1;
    unsigned char  : 1;
    unsigned char SCA1 : 1;
    unsigned char SCA0 : 1;
  } CKCON_bit;
} @ 0x8E;
__sfr __no_init volatile union
{
  unsigned char PLL0FLT; /* (Page: F) PLL Filter Register */
  unsigned char PSCTL; /* (Page: 0) Program Store Read/Write Control */
  struct /* (Page: F) PLL Filter Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char PLLICO1 : 1;
    unsigned char PLLICO0 : 1;
    unsigned char PLLLP3 : 1;
    unsigned char PLLLP2 : 1;
    unsigned char PLLLP1 : 1;
    unsigned char PLLLP0 : 1;
  } PLL0FLT_bit;
  struct /* (Page: 0) Program Store Read/Write Control */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char SFLE : 1;
    unsigned char PSEE : 1;
    unsigned char PSWE : 1;
  } PSCTL_bit;
} @ 0x8F;
__sfr __no_init volatile union
{
  unsigned char PSBANK; /* (All Pages) Program Space Bank Select Register */
  struct /* (All Pages) Program Space Bank Select Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char COBANK1 : 1;
    unsigned char COBANK0 : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char IFBANK1 : 1;
    unsigned char IFBANK0 : 1;
  } PSBANK_bit;
} @ 0xB1;
__sfr __no_init volatile unsigned char SFRPAGE @ 0x84; /* (All Pages) SFR Page Register */
__sfr __no_init volatile unsigned char SFRNEXT @ 0x85; /* (All Pages) SFR Next Register */
__sfr __no_init volatile unsigned char SFRLAST @ 0x86; /* (All Pages) SFR Last Register */
__sfr __no_init volatile union
{
  unsigned char PCON; /* (All Pages) Power Control */
  struct /* (All Pages) Power Control */
  {
    unsigned char PCON0 : 1;
    unsigned char PCON1 : 1;
    unsigned char PCON2 : 1;
    unsigned char PCON3 : 1;
    unsigned char PCON4 : 1;
    unsigned char PCON5 : 1;
    unsigned char STOP : 1;
    unsigned char IDLE : 1;
  } PCON_bit;
} @ 0x87;
__sfr __no_init volatile union
{
  unsigned char OSCICN; /* (Page: F) Internal Oscillator Control Register */
  unsigned char TL0; /* (Page: 0) Timer 0 Low Byte */
  struct /* (Page: F) Internal Oscillator Control Register */
  {
    unsigned char IOSCEN : 1;
    unsigned char IFRDY : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char IFCN1 : 1;
    unsigned char IFCN0 : 1;
  } OSCICN_bit;
  struct /* (Page: 0) Timer 0 Low Byte */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } TL0_bit;
} @ 0x8A;
__sfr __no_init volatile union
{
  unsigned char OSCICL; /* (Page: F) Internal Oscillator Calibration Register */
  unsigned char TL1; /* (Page: 0) Timer 1 Low Byte */
  struct /* (Page: F) Internal Oscillator Calibration Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } OSCICL_bit;
  struct /* (Page: 0) Timer 1 Low Byte */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } TL1_bit;
} @ 0x8B;

/*-------------------------------------------------------------------------
 *   AMUX
 *-------------------------------------------------------------------------*/

__sfr __no_init volatile union
{
  unsigned char AMX0SL; /* (Page: 0) AMUX0 Channel Select Register */
  unsigned char AMX2SL; /* (Page: 2) AMUX2 Channel Select Register */
  union
  {
    struct /* (Page: 0) AMUX0 Channel Select Register */
    {
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char AMX0AD3 : 1;
      unsigned char AMX0AD2 : 1;
      unsigned char AMX0AD1 : 1;
      unsigned char AMX0AD0 : 1;
    };
    struct /* (Page: 0) AMUX0 Channel Select Register */
    {
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
    };
  } AMX0SL_bit;
  struct /* (Page: 2) AMUX2 Channel Select Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char AMX2AD2 : 1;
    unsigned char AMX2AD1 : 1;
    unsigned char AMX2AD0 : 1;
  } AMX2SL_bit;
} @ 0xBB;
__sfr __no_init volatile union
{
  unsigned char AMX0CF; /* (Page: 0) AMUX0 Configuration Register */
  unsigned char AMX2CF; /* (Page: 2) AMUX2 Configuration Register */
  union
  {
    struct /* (Page: 0) AMUX0 Configuration Register */
    {
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char AIN67IC : 1;
      unsigned char AIN45IC : 1;
      unsigned char AIN23IC : 1;
      unsigned char AIN01IC : 1;
    };
    struct /* (Page: 0) AMUX0 Configuration Register */
    {
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
      unsigned char  : 1;
    };
  } AMX0CF_bit;
  struct /* (Page: 2) AMUX2 Configuration Register */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char PIN67IC : 1;
    unsigned char PIN45IC : 1;
    unsigned char PIN23IC : 1;
    unsigned char PIN01IC : 1;
  } AMX2CF_bit;
} @ 0xBA;

/*-------------------------------------------------------------------------
 *   Timer
 *-------------------------------------------------------------------------*/

__sfr __no_init volatile union
{
  unsigned char TMR2L; /* (Page: 0) Timer 2 Low Byte */
  unsigned char TMR3L; /* (Page: 1) Timer 3 Low Byte */
  unsigned char TMR4L; /* (Page: 2) Timer 4 Low Byte */
  struct /* (Page: 0) Timer 2 Low Byte */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } TMR2L_bit;
  struct /* (Page: 1) Timer 3 Low Byte */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } TMR3L_bit;
  struct /* (Page: 2) Timer 4 Low Byte */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } TMR4L_bit;
} @ 0xCC;
__sfr __no_init volatile union
{
  unsigned char TMR2CF; /* (Page: 0) Timer 2 Configuration Registers */
  unsigned char TMR3CF; /* (Page: 1) Timer 3 Configuration Registers */
  unsigned char TMR4CF; /* (Page: 2) Timer 4 Configuration Registers */
  struct /* (Page: 0) Timer 2 Configuration Registers */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char T2M1 : 1;
    unsigned char T2M0 : 1;
    unsigned char TOG2 : 1;
    unsigned char T2OE : 1;
    unsigned char DCEN : 1;
  } TMR2CF_bit;
  struct /* (Page: 1) Timer 3 Configuration Registers */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char T3M1 : 1;
    unsigned char T3M0 : 1;
    unsigned char TOG3 : 1;
    unsigned char T3OE : 1;
    unsigned char DCEN : 1;
  } TMR3CF_bit;
  struct /* (Page: 2) Timer 4 Configuration Registers */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char T4M1 : 1;
    unsigned char T4M0 : 1;
    unsigned char TOG4 : 1;
    unsigned char T4OE : 1;
    unsigned char DCEN : 1;
  } TMR4CF_bit;
} @ 0xC9;
__sfr __no_init volatile union
{
  unsigned char TMR2H; /* (Page: 0) Timer 2 High Byte */
  unsigned char TMR3H; /* (Page: 1) Timer 3 High Byte */
  unsigned char TMR4H; /* (page 2) Timer 4 High Byte */
  struct /* (Page: 0) Timer 2 High Byte */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } TMR2H_bit;
  struct /* (Page: 1) Timer 3 High Byte */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } TMR3H_bit;
  struct /* (page 2) Timer 4 High Byte */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } TMR4H_bit;
} @ 0xCD;
__sfr __no_init volatile union
{
  unsigned char RCAP2L; /* (Page: 0) Timer 2 Capture Register Low Byte */
  unsigned char RCAP3L; /* (Page: 1) Timer 3 Capture Register Low Byte */
  unsigned char RCAP4L; /* (Page: 2) Timer 4 Capture Register Low Byte */
  struct /* (Page: 0) Timer 2 Capture Register Low Byte */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } RCAP2L_bit;
  struct /* (Page: 1) Timer 3 Capture Register Low Byte */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } RCAP3L_bit;
  struct /* (Page: 2) Timer 4 Capture Register Low Byte */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } RCAP4L_bit;
} @ 0xCA;
__sfr __no_init volatile union
{
  unsigned char RCAP2H; /* (Page: 0) Timer 2 Capture Register High Byte */
  unsigned char RCAP3H; /* (Page: 1) Timer 3 Capture Register High Byte */
  unsigned char RCAP4H; /* (Page: 2) Timer 4 Capture Register High Byte */
  struct /* (Page: 0) Timer 2 Capture Register High Byte */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } RCAP2H_bit;
  struct /* (Page: 1) Timer 3 Capture Register High Byte */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } RCAP3H_bit;
  struct /* (Page: 2) Timer 4 Capture Register High Byte */
  {
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
    unsigned char  : 1;
  } RCAP4H_bit;
} @ 0xCB;
/*
 * Interrupt Vectors
 */
#define IE0_int 0x03 /* External Interrupt 0 (/INT0) */
#define TF0_int 0x0B /* Timer 0 Overflow */
#define IE1_int 0x13 /* External Interrupt 1 (/INT1) */
#define TF1_int 0x1B /* Timer 1 Overflow */
#define TI0_int 0x23 /* UART0 */
#define RI0_int 0x23 /* UART0 */
#define TF2_int 0x2B /* Timer 2 */
#define EXF2_int 0x2B /* Timer 2 */
#define MODF_int 0x33 /* Serial Peripheral Interface */
#define WCOL_int 0x33 /* Serial Peripheral Interface */
#define RXOVRN_int 0x33 /* Serial Peripheral Interface */
#define SPIF_int 0x33 /* Serial Peripheral Interface */
#define SI_int 0x3B /* SMBus Interface */
#define AD0WINT_int 0x43 /* ADC0 Window Comparator */
#define CCF4_int 0x4B /* PCA 0 */
#define CCF2_int 0x4B /* PCA 0 */
#define CCF1_int 0x4B /* PCA 0 */
#define CF_int 0x4B /* PCA 0 */
#define CCF6_int 0x4B /* PCA 0 */
#define CCF5_int 0x4B /* PCA 0 */
#define CCF7_int 0x4B /* PCA 0 */
#define CCF3_int 0x4B /* PCA 0 */
#define CCF0_int 0x4B /* PCA 0 */
#define CP0FIF_int 0x53 /* Comparator 0 Falling Edge */
#define CP0RIF_int 0x5B /* Comparator 0 Rising Edge */
#define CP1FIF_int 0x63 /* Comparator 1 Falling Edge */
#define CP1RIF_int 0x6B /* Comparator 1 Rising Edge */
#define TF3_int 0x73 /* Timer 3 */
#define EXF3_int 0x73 /* Timer 3 */
#define AD0INT_int 0x7B /* ADC0 End of Conversion */
#define EXF4_int 0x83 /* Timer 4 */
#define TF4_int 0x83 /* Timer 4 */
#define AD2WINT_int 0x8B /* ADC2 Window Comparator */
#define AD2INT_int 0x93 /* ADC2 End of Conversion */
#define RI1_int 0xA3 /* UART1 */
#define TI1_int 0xA3 /* UART1 */

#pragma language=default
#endif  /* __IAR_SYSTEMS_ICC__  */

/***************************************************************************
 *   Assembler definitions
 *
 *   The following SFRs are known by the a8051.exe and do not need to be
 *   defined explicitly:
 *     SBUF,SCON,TCON,PCON,TH0,TH1,TL0,TL1,TMOD,ACC,B,PSW,SP,DPL,DPH
 *     P0,P1,P2,P3,IE,IP
 *   And the bit name for above SFRs:
 *     OV,AC,F0,EA,ES,ET1,EX1,ET0,EX0,PS,PT1,PX1,PT0,PX0,RD,WR,T1,T0,INT1
 *     INT0,TXD,RXD,RS0,RS1,P,SM0,SM1,SM2,REN,TB8,RB8,TI,RI,TF1,TR1,TF0
 *     TR0,IE1,IT1,IE0,IT0
 ***************************************************************************/

#ifdef __IAR_SYSTEMS_ASM__


/*-------------------------------------------------------------------------
 *   External Memory
 *-------------------------------------------------------------------------*/

EMI0CF DEFINE 0xA3 /* (Page: 0) External Memory Configuration */
EMI0CN DEFINE 0xA2 /* (Page: 0) External Memory Interface Control */
EMI0TC DEFINE 0xA1 /* (Page: 0) External Memory Timing Control */

/*-------------------------------------------------------------------------
 *   ADC
 *-------------------------------------------------------------------------*/

ADC0CF DEFINE 0xBC /* (Page: 0) ADC0 Configuration Register */
ADC0CN DEFINE 0xE8 /* (Page: 0) ADC0 Control Register */
ADC0GTH DEFINE 0xC5 /* (Page: 0) ADC0 Greater-Than Data High Byte Register */
ADC0GTL DEFINE 0xC4 /* (Page: 0) ADC0 Greater-Than Data Low Byte Register */
ADC0H DEFINE 0xBF /* (Page: 0) ADC0 Data Word MSB Register */
ADC0L DEFINE 0xBE /* (Page: 0) ADC0 Data Word LSB Register */
ADC0LTH DEFINE 0xC7 /* (Page: 0) ADC0 Less-Than Data High Byte Register */
ADC0LTL DEFINE 0xC6 /* (Page: 0) ADC0 Less-Than Data Low Byte Register */
ADC2 DEFINE 0xBE /* (Page: 2) ADC2 Data Word Register */
ADC2CF DEFINE 0xBC /* (Page: 2) ADC2 Configuration Register */
ADC2CN DEFINE 0xE8 /* (Page: 2) ADC2 Control Register */
ADC2GT DEFINE 0xC4 /* (Page: 2) ADC2 Greater-Than Data Byte Register */
ADC2LT DEFINE 0xC6 /* (Page: 2) ADC2 Less-Than Data Byte Register */
REF0CN DEFINE 0xD1 /* (Page: 0) Reference Control Register */
RSTSRC DEFINE 0xEF /* (Page: 0) Reset Source Register */

/*-------------------------------------------------------------------------
 *   SPI
 *-------------------------------------------------------------------------*/

SPI0CFG DEFINE 0x9A /* (Page: 0) SPI0 Configuration Register */
SPI0CKR DEFINE 0x9D /* (Page: 0) SPI0 Clock Rate Register */
SPI0CN DEFINE 0xF8 /* (Page: 0) SPI0 Control Register */
SPI0DAT DEFINE 0x9B /* (Page: 0) SPI0 Data Register */

/*-------------------------------------------------------------------------
 *   PCA
 *-------------------------------------------------------------------------*/

PCA0CN DEFINE 0xD8 /* (Page: 0) PCA Control Register */
PCA0CPH0 DEFINE 0xFC /* (Page: 0) PCA0 Capture Module High Byte 0 */
PCA0CPH1 DEFINE 0xFD /* (Page: 0) PCA0 Capture Module High Byte 1 */
PCA0CPH2 DEFINE 0xEA /* (Page: 0) PCA0 Capture Module High Byte 2 */
PCA0CPH3 DEFINE 0xEC /* (Page: 0) PCA0 Capture Module High Byte 3 */
PCA0CPH4 DEFINE 0xEE /* (Page: 0) PCA0 Capture Module High Byte 4 */
PCA0CPH5 DEFINE 0xE2 /* (Page: 0) PCA0 Capture Module High Byte 5 */
PCA0CPL0 DEFINE 0xFB /* (Page: 0) PCA0 Capture Module Low Byte 0 */
PCA0CPL1 DEFINE 0xFD /* (Page: 0) PCA0 Capture Module Low Byte 1 */
PCA0CPL2 DEFINE 0xE9 /* (Page: 0) PCA0 Capture Module Low Byte 2 */
PCA0CPL3 DEFINE 0xEB /* (Page: 0) PCA0 Capture Module Low Byte 3 */
PCA0CPL4 DEFINE 0xED /* (Page: 0) PCA0 Capture Module Low Byte 4 */
PCA0CPL5 DEFINE 0xE1 /* (Page: 0) PCA0 Capture Module Low Byte 5 */
PCA0CPM0 DEFINE 0xDA /* (Page: 0) PCA0 Capture/Compare Mode Registers 0 */
PCA0CPM1 DEFINE 0xDB /* (Page: 0) PCA0 Capture/Compare Mode Registers 1 */
PCA0CPM2 DEFINE 0xDC /* (Page: 0) PCA0 Capture/Compare Mode Registers 2 */
PCA0CPM3 DEFINE 0xDD /* (Page: 0) PCA0 Capture/Compare Mode Registers 3 */
PCA0CPM4 DEFINE 0xDE /* (Page: 0) PCA0 Capture/Compare Mode Registers 4 */
PCA0CPM5 DEFINE 0xDF /* (Page: 0) PCA0 Capture/Compare Mode Registers 5 */
PCA0H DEFINE 0xFA /* (Page: 0) PCA0 Counter/Timer High Byte */
PCA0L DEFINE 0xF9 /* (Page: 0) PCA0 Counter/Timer Low Byte */
PCA0MD DEFINE 0xD9 /* (Page: 0) PCA0 Mode Register */

/*-------------------------------------------------------------------------
 *   Interrupt
 *-------------------------------------------------------------------------*/

EIE1 DEFINE 0xE6 /* (All Pages) Extended Interrupt Enable 1 */
EIE2 DEFINE 0xE7 /* (All Pages) Extended Interrupt Enable 2 */
EIP1 DEFINE 0xF6 /* (All Pages) Extended Interrupt Priority 1 */
EIP2 DEFINE 0xF7 /* (All Pages) Extended Interrupt Priority 2 */

/*-------------------------------------------------------------------------
 *   MAC
 *-------------------------------------------------------------------------*/

MAC0ACC0 DEFINE 0x93 /* (Page: 3) MAC0 Accumulator Byte 0 Register */
MAC0ACC1 DEFINE 0x94 /* (Page: 3) MAC0 Accumulator Byte 1 Register */
MAC0ACC2 DEFINE 0x95 /* (Page: 3) MAC0 Accumulator Byte 2 Register */
MAC0ACC3 DEFINE 0x96 /* (Page: 3) MAC0 Accumulator Byte 3 Register */
MAC0AH DEFINE 0xC2 /* (Page: 3) MAC0 A High Byte Register */
MAC0AL DEFINE 0xC1 /* (Page: 3) MAC0 A Low Byte Register */
MAC0BH DEFINE 0x92 /* (Page: 3) MAC0 B High Byte Register */
MAC0BL DEFINE 0x91 /* (Page: 3) MAC0 B Low Byte Register */
MAC0CF DEFINE 0xC3 /* (Page: 3) MAC0 Configuration Register */
MAC0OVR DEFINE 0x97 /* (Page: 3) MAC0 Accumulator Overflow Register */
MAC0RNDH DEFINE 0xCF /* (Page: 3) MAC0 Rounding Register High Byte */
MAC0RNDL DEFINE 0xCE /* (Page: 3) MAC0 Rounding Register Low Byte */
MAC0STA DEFINE 0xC0 /* (Page: 3) MAC0 Status Register */

/*-------------------------------------------------------------------------
 *   Comparator
 *-------------------------------------------------------------------------*/

CPT0CN DEFINE 0x88 /* (Page: 1) Comparator0 Control Register */
CPT0MD DEFINE 0x89 /* (Page: 1) Comparator0 Mode Selection Register */
CPT1CN DEFINE 0x88 /* (Page: 2) Comparator1 Control Register */
CPT1MD DEFINE 0x89 /* (Page: 2) Comparator1 Mode Selection Register */

/*-------------------------------------------------------------------------
 *   Other
 *-------------------------------------------------------------------------*/

DC0H DEFINE 0xBF

/*-------------------------------------------------------------------------
 *   SMBus
 *-------------------------------------------------------------------------*/

SMB0ADR DEFINE 0xC3 /* (Page: 0) SMBus0 Address Register */
SMB0CN DEFINE 0xC0 /* (Page: 0) SMBus0 Control Register */
SMB0CR DEFINE 0xCF /* (Page: 0) SMBus0 Clock Rate Register */
SMB0DAT DEFINE 0xC2 /* (Page: 0) SMBus0 Data Register */
SMB0STA DEFINE 0xC1 /* (Page: 0) SMBus0 Status Register */

/*-------------------------------------------------------------------------
 *   I/O Port
 *-------------------------------------------------------------------------*/

P0MDOUT DEFINE 0xA4 /* (Page: F) Port0 Output Mode Register */
P1MDIN DEFINE 0xAD /* (Page: F) Port1 Input Mode Register */
P1MDOUT DEFINE 0xA5 /* (Page: F) Port1 Output Mode Register */
P2MDOUT DEFINE 0xA6 /* (Page: F) Port2 Output Mode Register */
P3MDOUT DEFINE 0xA7 /* (Page: F) Port3 Output Mode Register */
P4 DEFINE 0xC8 /* (Page: F) Port4 Data Register */
P4MDOUT DEFINE 0x9C /* (Page: F) Port4 Output Mode Register */
P5 DEFINE 0xD8 /* (Page: F) Port5 Data Register */
P5MDOUT DEFINE 0x9D /* (Page: F) Port5 Output Mode Register */
P6 DEFINE 0xE8 /* (Page: F) Port6 Data Register */
P6MDOUT DEFINE 0x9E /* (Page: F) Port6 Output Mode Register */
P7 DEFINE 0xF8 /* (Page: F) Port7 Data Register */
P7MDOUT DEFINE 0x9F /* (Page: F) Port7 Output Mode Register */
XBR0 DEFINE 0xE1 /* (Page: F) Port I/O Crossbar Register 0 */
XBR1 DEFINE 0xE2 /* (Page: F) Port I/O Crossbar Register 1 */
XBR2 DEFINE 0xE3 /* (Page: F) Port I/O Crossbar Register 2 */

/*-------------------------------------------------------------------------
 *   Flash Memory
 *-------------------------------------------------------------------------*/

FLACL DEFINE 0xB7 /* (Page: F) FLASH Access Limit */
FLSCL DEFINE 0xB7 /* (Page: 0) FLASH Memory Control */
FLSTAT DEFINE 0x88 /* (Page: F) FLASH Status */

/*-------------------------------------------------------------------------
 *   DAC
 *-------------------------------------------------------------------------*/

DAC0CN DEFINE 0xD4 /* (Page: 0) DAC0 Control Register */
DAC0H DEFINE 0xD3 /* (Page: 0) DAC0 High Byte Register */
DAC0L DEFINE 0xD2 /* (Page: 0) DAC0 Low Byte Register */
DAC1CN DEFINE 0xD4 /* (Page: 1) DAC1 Control Register */
DAC1H DEFINE 0xD3 /* (Page: 1) DAC1 High Byte Register */
DAC1L DEFINE 0xD2 /* (Page: 1) DAC1 Low Byte Register */

/*-------------------------------------------------------------------------
 *   Cache
 *-------------------------------------------------------------------------*/

CCH0CN DEFINE 0xA1 /* (Page: F) Cache Control Register */
CCH0LC DEFINE 0xA3 /* (Page: F) Cache Lock Control Register */
CCH0MA DEFINE 0x9A /* (Page: F) Cache Miss Accumulator */
CCH0TN DEFINE 0xA2 /* (Page: F) Cache Tuning Register */

/*-------------------------------------------------------------------------
 *   WDT
 *-------------------------------------------------------------------------*/

WDTCN DEFINE 0xFF /* (All Pages) Watchdog Timer Control Register */

/*-------------------------------------------------------------------------
 *   Serial I/O
 *-------------------------------------------------------------------------*/

SADDR0 DEFINE 0xA9 /* (Page: 0) UART0 Slave Address Register */
SADEN0 DEFINE 0xB9 /* (Page: 0) UART0 Slave Address Enable Register */
SBUF0 DEFINE 0x99 /* (Page: 0) UART0 Data Buffer Register */
SBUF1 DEFINE 0x99 /* (Page: 1) Serial (UART1) Port Data Buffer Register */
SCON0 DEFINE 0x98 /* (Page: 0) UART0 Control Register */
SCON1 DEFINE 0x98 /* (Page: 1) Serial Port 1 Control Register */
SSTA0 DEFINE 0x91 /* (Page: 0) UART0 Status and Clock Selection Register */

/*-------------------------------------------------------------------------
 *   System Administration
 *-------------------------------------------------------------------------*/

OSCICL DEFINE 0x8B /* (Page: F) Internal Oscillator Calibration Register */
OSCICN DEFINE 0x8A /* (Page: F) Internal Oscillator Control Register */
OSCXCN DEFINE 0x8C /* (Page: F) External Oscillator Control Register */
PLL0CN DEFINE 0x89 /* (Page: F) PLL Control Register */
PLL0DIV DEFINE 0x8D /* (Page: F) PLL Pre-divider Register */
PLL0FLT DEFINE 0x8F /* (Page: F) PLL Filter Register */
PLL0MUL DEFINE 0x8E /* (Page: F) PLL Clock Scaler Register */
PSBANK DEFINE 0xB1 /* (All Pages) Program Space Bank Select Register */
PSCTL DEFINE 0x8F /* (Page: 0) Program Store Read/Write Control */
SFRLAST DEFINE 0x86 /* (All Pages) SFR Last Register */
SFRNEXT DEFINE 0x85 /* (All Pages) SFR Next Register */
SFRPAGE DEFINE 0x84 /* (All Pages) SFR Page Register */
SFRPGCN DEFINE 0x96 /* (Page: F) SFR Page Control Register */

/*-------------------------------------------------------------------------
 *   AMUX
 *-------------------------------------------------------------------------*/

AMX0CF DEFINE 0xBA /* (Page: 0) AMUX0 Configuration Register */
AMX0SL DEFINE 0xBB /* (Page: 0) AMUX0 Channel Select Register */
AMX2CF DEFINE 0xBA /* (Page: 2) AMUX2 Configuration Register */
AMX2SL DEFINE 0xBB /* (Page: 2) AMUX2 Channel Select Register */

/*-------------------------------------------------------------------------
 *   Timer
 *-------------------------------------------------------------------------*/

CKCON DEFINE 0x8E /* (Page: 0) Clock Control Register */
CLKSEL DEFINE 0x97 /* (Page: F) System Clock Selection Register */
RCAP2H DEFINE 0xCB /* (Page: 0) Timer 2 Capture Register High Byte */
RCAP2L DEFINE 0xCA /* (Page: 0) Timer 2 Capture Register Low Byte */
RCAP3H DEFINE 0xCB /* (Page: 1) Timer 3 Capture Register High Byte */
RCAP3L DEFINE 0xCA /* (Page: 1) Timer 3 Capture Register Low Byte */
RCAP4H DEFINE 0xCB /* (Page: 2) Timer 4 Capture Register High Byte */
RCAP4L DEFINE 0xCA /* (Page: 2) Timer 4 Capture Register Low Byte */
TMR2CF DEFINE 0xC9 /* (Page: 0) Timer 2 Configuration Registers */
TMR2CN DEFINE 0xC8 /* (Page: 0) Timer 2 Control Registers */
TMR2H DEFINE 0xCD /* (Page: 0) Timer 2 High Byte */
TMR2L DEFINE 0xCC /* (Page: 0) Timer 2 Low Byte */
TMR3CF DEFINE 0xC9 /* (Page: 1) Timer 3 Configuration Registers */
TMR3CN DEFINE 0xC8 /* (Page: 1) Timer 3 Control Registers */
TMR3H DEFINE 0xCD /* (Page: 1) Timer 3 High Byte */
TMR3L DEFINE 0xCC /* (Page: 1) Timer 3 Low Byte */
TMR4CF DEFINE 0xC9 /* (Page: 2) Timer 4 Configuration Registers */
TMR4CN DEFINE 0xC8 /* (Page: 2) Timer 4 Control Registers */
TMR4H DEFINE 0xCD /* (page 2) Timer 4 High Byte */
TMR4L DEFINE 0xCC /* (Page: 2) Timer 4 Low Byte */

#endif /* __IAR_SYSTEMS_ASM__*/
