//-----------------------------------------------------------------------------
// F326_AES_Main.c
//-----------------------------------------------------------------------------
// Copyright 2007 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
//
// How To Test:    See Readme.txt
//
// 
// Target:         C8051F326
// Tool chain:     Keil C51 7.50 / Keil EVAL C51
//                 Silicon Laboratories IDE version 2.91
// Command Line:   See Readme.txt
// Project Name:   F326_AES
//
//
// Release 1.0
//    -Initial Revision (CG/GP)
//    -11 JUN 2007
//

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------

#include <c8051f326.h>                 // SFR declarations

#include "F326_AES_Typedef.h"
#include "F326_AES_Parameters.h"
#include "F326_AES_KeyExpander.h"
#include "F326_AES_Cipher.h"
#include "F326_AES_InvCipher.h"

//-----------------------------------------------------------------------------
// 16-bit SFR definitions
//-----------------------------------------------------------------------------

sfr16 TMR0 = 0x8A;                       // Timer 0

//-----------------------------------------------------------------------------
// Global Constants
//-----------------------------------------------------------------------------

// The data that is encrypted

code const byte InData[DATA_LENGTH] = { 0x00,0x11,0x22,0x33,
                                        0x44,0x55,0x66,0x77,
                                        0x88,0x99,0xAA,0xBB,
                                        0xCC,0xDD,0xEE,0xFF };

//-----------------------------------------------------------------------------
// Global Variables
//-----------------------------------------------------------------------------

xdata byte EncryptedData[DATA_LENGTH];    // Stores ciphered array
xdata byte PlaintextData[DATA_LENGTH];    // Stores deciphered array

//-----------------------------------------------------------------------------
// Function Prototypes
//-----------------------------------------------------------------------------

void OSCILLATOR_Init (void);
void TIMER0_Init (void); 

//-----------------------------------------------------------------------------
// MAIN Routine
//-----------------------------------------------------------------------------

void main(void)
{
   INT encrypt_cycles;                 
   INT decrypt_cycles;                 
   INT key_exp_cycles;

   OSCILLATOR_Init ();
   TIMER0_Init ();

   encrypt_cycles.i = 0;               // Initialize variables
   decrypt_cycles.i = 0;
   key_exp_cycles.i = 0;

   TL0 = 0x00;                         // Clear Timer
   TH0 = 0x00;
   TR0 = 1;                            // Start Timer

   KeyExpansion ();                    // Generate expanded keys

   TR0 = 0;                            // Stop Timer

   key_exp_cycles.b[0] = TH0;          // Record # cycles for KeyExpansion
   key_exp_cycles.b[1] = TL0;

   TL0 = 0x00;
   TH0 = 0x00;
   TR0 = 1;

   Cipher (&InData[0], &EncryptedData[0]);         // Encrypt data

   TR0 = 0;

   encrypt_cycles.b[0] = TH0;          // Record # cycles to Encrypt 16 bytes
   encrypt_cycles.b[1] = TL0;

   TL0 = 0x00;
   TH0 = 0x00;
   TR0 = 1;

   InvCipher (&EncryptedData[0],&PlaintextData[0]); // Decrypt data

   TR0 = 0;

   decrypt_cycles.b[0] = TH0;          // Record # cycles to Decrypt 16 bytes
   decrypt_cycles.b[1] = TL0;

   while (1) {}
}

//-----------------------------------------------------------------------------
// Initialization Subroutines
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// OSCILLATOR_Init
//-----------------------------------------------------------------------------
//
// Return Value : None
// Parameters   : None
//
// Initialize the system clock to 24 Mhz and the USB clock to 24 Mhz
//
//-----------------------------------------------------------------------------

void OSCILLATOR_Init (void)
{
   unsigned char delay = 100;

   OSCICN |= 0x03;                     // Configure internal oscillator for
                                       // its maximum frequency

   CLKMUL = 0x00;                      // Select internal oscillator as
                                       // input to clock multiplier

   CLKMUL |= 0x80;                     // Enable clock multiplier
   while (delay--);                    // Delay for >5us
   CLKMUL |= 0xC0;                     // Initialize the clock multiplier

   while(!(CLKMUL & 0x20));            // Wait for multiplier to lock

   CLKSEL = 0x02;                      // Select USB clock as CLK mul output
                                       // Select SYSCLK as Clock Multiplier/2
}

//-----------------------------------------------------------------------------
// TIMER0_Init
//-----------------------------------------------------------------------------
//
// Return Value : None
// Parameters   : None
//
// Initialize Timer0 to run in 16-bit counter mode with SYSCLK as clock
// The Timer is used to measure the performance of the AES routines
//
//-----------------------------------------------------------------------------

void TIMER0_Init (void)
{
   TCON = 0x00;                        // Disable Timer0 and clear Timer0 flag

   TMOD = 0x01;                        // Timer0 runs when TR0 = 1
                                       // Timer runs in 16-bit mode

   CKCON = 0x04;                       // Timer0 runs from SYSCLK

}

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------