//-----------------------------------------------------------------------------
// F50x_CAN.h - CAN_BL - Master_BL_FW
//-----------------------------------------------------------------------------
// Copyright (C) 2009 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This program performs as the Master for the CAN bootloader.
// PC (Data Source) <--> UART <--> MCU (Master) <--> CAN <--> MCU (Target)
//
//
// Target:         C8051F500 (Side A of a C8051F500-TB)
// Tool chain:     Keil C51 8.0 / Keil EVAL C51
// Command Line:   None
//
//
// Release 1.0 / 18NOV2009 (PKC)
//    -Initial Revision
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Header File Preprocessor Directive
//-----------------------------------------------------------------------------
#ifndef F50X_CAN_H
#define F50X_CAN_H

//-----------------------------------------------------------------------------
// Global CONSTANTS
//-----------------------------------------------------------------------------

// "request_response" parameter values (for TGT_Enter_BL_Mode function)
#define IGNORE_RESPONSE 0x00
#define REQUEST_RESPONSE 0x01

//------------------------
// Bit Definition Masks
//------------------------

// CAN0STAT
#define BOff  0x80                     // Busoff Status
#define EWarn 0x40                     // Warning Status
#define EPass 0x20                     // Error Passive
#define RxOk  0x10                     // Receive Message Successfully
#define TxOk  0x08                     // Transmitted Message Successfully
#define LEC   0x07                     // Last Error Code


//-----------------------------------------------------------------------------
// Function Prototypes
//-----------------------------------------------------------------------------
void CAN0_Init (void);

uint8_t TGT_Enter_BL_Mode (uint8_t request_response, uint8_t CAN_dev_addr);
uint8_t TGT_Get_Info (uint8_t *target_info);
uint8_t TGT_Set_Flash_Keys (uint8_t flash_key0, uint8_t flash_key1);
uint8_t TGT_Set_Addr (uint8_t bank, uint32_t addr);
uint8_t TGT_Erase_Page (void);
uint8_t TGT_Write_Flash (uint8_t *buf, uint16_t index, uint8_t numbytes);
uint8_t TGT_Get_Page_CRC (uint16_t *target_page_crc);
uint8_t TGT_Write_Signature (uint8_t sig_byte0, uint8_t sig_byte1, uint8_t sig_byte2, uint8_t sig_byte3);
void TGT_SW_Reset (void);

//-----------------------------------------------------------------------------
// Header File Preprocessor Directive
//-----------------------------------------------------------------------------
#endif

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------
