//-----------------------------------------------------------------------------
// F50x_Main.h - CAN_BL - Master_BL_FW
//-----------------------------------------------------------------------------
// Copyright (C) 2009 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This program performs as the Master for the CAN bootloader.
// PC (Data Source) <--> UART <--> MCU (Master) <--> CAN <--> MCU (Target)
//
//
// Target:         C8051F500 (Side A of a C8051F500-TB)
// Tool chain:     Keil C51 8.0 / Keil EVAL C51
// Command Line:   None
//
//
// Release 1.0 / 18NOV2009 (PKC)
//    -Initial Revision
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Header File Preprocessor Directive
//-----------------------------------------------------------------------------
#ifndef F50X_MAIN_H
#define F50X_MAIN_H

//-----------------------------------------------------------------------------
// Global CONSTANTS
//-----------------------------------------------------------------------------

// LED State Values
#define LED_OFF      0x00
#define LED_ON       0x01
#define LED_BLINK_SLOW  0x02
#define LED_BLINK_FAST  0x03

// Flash Write/Erase Key Codes for Target MCU
#define FLASH_KEY0      0xA5
#define FLASH_KEY1      0xF1

//-----------------------------------------------------------------------------
// Global Variables - Externs
//-----------------------------------------------------------------------------
extern uint32_t Page_Addr;
extern uint16_t SRC_Page_CRC;
extern uint16_t TGT_Page_CRC;

extern uint8_t Pages_Written;

extern uint8_t LED_State;

SI_SEGMENT_VARIABLE(Page_Buf[PAGE_SIZE+2], extern uint8_t, SI_SEG_XDATA);
SI_SEGMENT_VARIABLE(TGT_Info[TGT_Enum_End_Value], extern uint8_t, SI_SEG_XDATA);
SI_SEGMENT_VARIABLE(SRC_Info[SRC_Enum_End_Value], extern uint8_t, SI_SEG_XDATA);

//-----------------------------------------------------------------------------
// Function Prototypes
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// Header File Preprocessor Directive
//-----------------------------------------------------------------------------
#endif

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------
