//-----------------------------------------------------------------------------
// F50x_UART.h - CAN_BL - Master_BL_FW
//-----------------------------------------------------------------------------
// Copyright (C) 2009 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This program performs as the Master for the CAN bootloader.
// PC (Data Source) <--> UART <--> MCU (Master) <--> CAN <--> MCU (Target)
//
//
// Target:         C8051F500 (Side A of a C8051F500-TB)
// Tool chain:     Keil C51 8.0 / Keil EVAL C51
// Command Line:   None
//
//
// Release 1.0 / 18NOV2009 (PKC)
//    -Initial Revision
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Header File Preprocessor Directive
//-----------------------------------------------------------------------------
#ifndef F50X_UART_H
#define F50X_UART_H

//-----------------------------------------------------------------------------
// Global CONSTANTS
//-----------------------------------------------------------------------------
#define BAUDRATE 115200
#define ADDL_RX_BYTES_GET_PAGE   2

//-----------------------------------------------------------------------------
// Function Prototypes (Global)
//-----------------------------------------------------------------------------
uint8_t SRC_Get_Info (uint8_t *src_info);
uint8_t SRC_Get_Page_Info (uint32_t *addr, uint16_t *src_page_crc);
uint8_t SRC_Get_Page (uint8_t *buf);
uint8_t SRC_Disp_TGT_Info (uint8_t buf_length, uint8_t *buf);
uint8_t SRC_Disp_Info_Code (uint8_t info_code);

//-----------------------------------------------------------------------------
// Header File Preprocessor Directive
//-----------------------------------------------------------------------------
#endif

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------
