//-----------------------------------------------------------------------------
// F50x_Validation.h - CAN_BL - Master_BL_FW
//-----------------------------------------------------------------------------
// Copyright (C) 2009 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This program performs as the Master for the CAN bootloader.
// PC (Data Source) <--> UART <--> MCU (Master) <--> CAN <--> MCU (Target)
//
//
// Target:         C8051F500 (Side A of a C8051F500-TB)
// Tool chain:     Keil C51 8.0 / Keil EVAL C51
// Command Line:   None
//
//
// Release 1.0 / 18NOV2009 (PKC)
//    -Initial Revision
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Header File Preprocessor Directive
//-----------------------------------------------------------------------------
#ifndef F50X_VALIDATION_H
#define F50X_VALIDATION_H

//-----------------------------------------------------------------------------
// Global CONSTANTS
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Global Variables - Externs
//-----------------------------------------------------------------------------
extern uint8_t Last_Error;

//-----------------------------------------------------------------------------
// Function Prototypes
//-----------------------------------------------------------------------------
void TGT_Validate_Response (uint8_t response, uint8_t command);
void SRC_Validate_Response (uint8_t response, uint8_t command);
void Validate_TGT_SRC_Match (uint32_t *page_addr);
void Validate_Pages_Written (uint8_t num_pages_from_source);

//-----------------------------------------------------------------------------
// Header File Preprocessor Directive
//-----------------------------------------------------------------------------
#endif

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------
