//-----------------------------------------------------------------------------
// F50x_InfoBlock.c - CAN_BL - Target_BL_FW
//-----------------------------------------------------------------------------
// Copyright (C) 2009 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This file contains a set of bytes that will be placed as the last bytes of
// the App FW. The locating is done by using the linker command line.
//
// Locate starting at address (63*1024-512-7-4) = 0xF9F5
//
// Target:         C8051F500
// Tool chain:     Keil C51 8.0 / Keil EVAL C51
// Command Line:   None
//
//
// Release 1.0 / 18NOV2009 (PKC)
//    -Initial Revision
//
//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------
#include "si_toolchain.h"
#include "C8051F500_defs.h"

#include "F50x_Target_Interface.h"

//-----------------------------------------------------------------------------
// Global Variables
//-----------------------------------------------------------------------------

/*****************************************
Target App FW InfoBlock Format
Byte offset (from last byte) - Field

0	Signature Byte Low (0) (sig bytes are added by the bootloader after successful programming)
-1	Signature Byte (1)
-2	Signature Byte (2)
-3	Signature Byte High (3)
-4	InfoBlock Length = 7 (for CAN BL; count includes this length byte)
-5	MCU Code
-6	BL Type
-7	Flash Page Size Code
-8	Application FW Version Low (0)
-9	Application FW Version High (1)
-10	BL-specific byte (0) - CAN Device Addr - Not used for read by FW (only present for hex file image)
*****************************************/


/*
SI_SEGMENT_VARIABLE(TGT_App_InfoBlock[], const uint8_t, SI_SEG_CODE) =
{
	TGT_APP_INFOBLOCK_LENGTH,
	TGT_MCU_CODE,
	TGT_BL_TYPE,
	TGT_FLASH_PAGE_SIZE_CODE,
	APP_FW_VERSION_LOW,
	APP_FW_VERSION_HIGH,
	CAN_DEVICE_ADDR
};
*/

// Reverse byte order for Keil:
SI_SEGMENT_VARIABLE(TGT_App_InfoBlock[], const uint8_t, SI_SEG_CODE) =
{
	CAN_DEVICE_ADDR,
	APP_FW_VERSION_HIGH,
	APP_FW_VERSION_LOW,
	TGT_FLASH_PAGE_SIZE_CODE,
	TGT_BL_TYPE,
	TGT_MCU_CODE,
	TGT_APP_INFOBLOCK_LENGTH
};



//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------