//-----------------------------------------------------------------------------
// F50x_Target_Interface.h - CAN_BL - Target_BL_FW
//-----------------------------------------------------------------------------
// Copyright (C) 2009 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This is to be included in Target App FW project.
//
// Information presented in this header file is extracted from:
// F50x_Main.h, F50x_InfoBlock.c of the Target BL FW and F50x_Master_Interface.h
//
// Target:         C8051F500 (Side A of a C8051F500-TB)
// Tool chain:     Keil C51 8.0 / Keil EVAL C51
// Command Line:   None
//
//
// Release 1.0 / 18NOV2009 (PKC)
//    -Initial Revision
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Header File Preprocessor Directive
//-----------------------------------------------------------------------------
#ifndef F50X_TARGET_INTERFACE_H
#define F50X_TARGET_INTERFACE_H

//-----------------------------------------------------------------------------
// Global CONSTANTS
//-----------------------------------------------------------------------------

// Reserved space first byte
#define RESERVED_SPACE_ADDR (63*1024) // 0xFC00

// InfoBlock starts right next to the lock byte
#define TGT_BL_INFOBLOCK_START_ADDR (RESERVED_SPACE_ADDR-2)

// CAN Device Address is stored here:
#define CAN_DEVICE_ADDR_LOCATION (TGT_BL_INFOBLOCK_START_ADDR-15)

// Size of CAN Messages
#define BL_MESSAGE_SIZE   8        // Range is 1-8 bytes

// Message Objects to use (range 0-31)
#define MO_RX_BL_CMD    0x10

// 11-bit Arbitration Message IDs
#define MSG_ID_RX_BL_CMD      0x0B1 // Transmitted by Master MCU for all BL commands, except:


// Bootloader Command and Response Codes
#define TGT_CMD_ENTER_BL_MODE    0x90 // Enter Bootload Mode Command Code
#define TGT_RSP_APP_MODE         0x63 // Response from app FW to Master on EnterBLmode Request

// Defines for use in the InfoBlock
#define TGT_APP_INFOBLOCK_LENGTH 7

#define TGT_MCU_CODE             0x21  // Code for this MCU partnumber
#define TGT_BL_TYPE              0x02  // CAN BL
#define TGT_FLASH_PAGE_SIZE_CODE 0x01  // Flash Page Size Code: 1 => 512 bytes

// Customize for application FW
#define APP_FW_VERSION_HIGH      0x01
#define APP_FW_VERSION_LOW       0x01

// Customize for each node
#define CAN_DEVICE_ADDR          0x01

//-----------------------------------------------------------------------------
// Bit Definition Masks
//-----------------------------------------------------------------------------

// CAN0STAT
#define BOff  0x80                     // Busoff Status
#define EWarn 0x40                     // Warning Status
#define EPass 0x20                     // Error Passive
#define RxOk  0x10                     // Receive Message Successfully
#define TxOk  0x08                     // Transmitted Message Successfully
#define LEC   0x07                     // Last Error Code

//-----------------------------------------------------------------------------
// Function Prototypes
//-----------------------------------------------------------------------------
void CAN0_Init_For_BL_Support (void);
uint8_t Check_BL_Command (uint8_t status, uint8_t Interrupt_ID);
uint8_t Enter_BL_Mode (void);

//-----------------------------------------------------------------------------
// Header File Preprocessor Directive
//-----------------------------------------------------------------------------
#endif

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------
