//-----------------------------------------------------------------------------
// F50x_CAN.h - CAN_BL - Target_BL_FW
//-----------------------------------------------------------------------------
// Copyright (C) 2009 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This program performs as the Target Bootloader Firmware for the CAN bootloader.
// PC (Data Source) <--> UART <--> MCU (Master) <--> CAN <--> MCU (Target)
//
//
// Target:         C8051F500 (Side A of a C8051F500-TB)
// Tool chain:     Keil C51 8.0 / Keil EVAL C51
// Command Line:   None
//
//
// Release 1.0 / 18NOV2009 (PKC)
//    -Initial Revision
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Header File Preprocessor Directive
//-----------------------------------------------------------------------------
#ifndef F50X_CAN_H
#define F50X_CAN_H

//-----------------------------------------------------------------------------
// Global CONSTANTS
//-----------------------------------------------------------------------------

//------------------------
// Bit Definition Masks
//------------------------

// CAN0STAT
#define BOff  0x80                     // Busoff Status
#define EWarn 0x40                     // Warning Status
#define EPass 0x20                     // Error Passive
#define RxOk  0x10                     // Receive Message Successfully
#define TxOk  0x08                     // Transmitted Message Successfully
#define LEC   0x07                     // Last Error Code

//-----------------------------------------------------------------------------
// Global Variables - Externs
//-----------------------------------------------------------------------------
extern uint8_t CAN_Rx_Complete_Flag;        // CAN Rx Complete Flag

//-----------------------------------------------------------------------------
// Function Prototypes
//-----------------------------------------------------------------------------
void CAN0_Init (void);
void Wait_For_CAN_Rx_Complete (void);
void CAN_Send_Error (void);

void TGT_Enter_BL_Mode (void);
void TGT_Get_Info (void);
void TGT_Set_Flash_Keys (void);
void TGT_Set_Addr (void);
void TGT_Erase_Page (void);
void TGT_Write_Flash (void);
void TGT_Get_Page_CRC (void);
void TGT_Write_Signature (void);
void TGT_SW_Reset (void);


//-----------------------------------------------------------------------------
// Header File Preprocessor Directive
//-----------------------------------------------------------------------------
#endif

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------
