//-----------------------------------------------------------------------------
// F50x_CRC.c - CAN_BL - Target_BL_FW
//-----------------------------------------------------------------------------
// Copyright (C) 2009 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This program performs as the Target Bootloader Firmware for the CAN bootloader.
// PC (Data Source) <--> UART <--> MCU (Master) <--> CAN <--> MCU (Target)
// This file includes all the CRC-related functions.
//
//
// Target:         C8051F500 (Side A of a C8051F500-TB)
// Tool chain:     Keil C51 8.0 / Keil EVAL C51
// Command Line:   None
//
//
// Release 1.0 / 18NOV2009 (PKC)
//    -Initial Revision
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------
#include "si_toolchain.h"

#ifdef MASTER_MCU_BL
   #undef MASTER_MCU_BL
#endif

#include "F50x_Master_Interface.h"
#include "F50x_CRC.h"
#include "F50x_Main.h"

//-----------------------------------------------------------------------------
// Function Prototypes
//-----------------------------------------------------------------------------
uint16_t Update_CRC (uint16_t crc, uint8_t newbyte);

//=============================================================================
// Function Definitions
//=============================================================================

//-----------------------------------------------------------------------------
// Get_Page_CRC
//-----------------------------------------------------------------------------
//
// Return Value:  None
// Parameters:    None
//
// Returns a 16-bit CRC of the contents of a buffer.
//
//-----------------------------------------------------------------------------
uint16_t Get_Page_CRC (void)
{
   uint16_t i, crc;
   uint8_t code * data flash_ptr;

   flash_ptr = Page_Addr;
   crc = 0x0000;

   // Process each byte in the page into the running CRC
   for( i = 0; i < PAGE_SIZE; i++)
   {
      crc = Update_CRC (crc, *flash_ptr);
      flash_ptr++;
   }

   return crc;
}

//-----------------------------------------------------------------------------
// Update_CRC
//-----------------------------------------------------------------------------
//
// Return Value:  None
// Parameters:    None
//
// This function accepts a CRC argument and a <newbyte> and returns an
// updated CRC value; Does not use a CRC Lookup Table.
//
//-----------------------------------------------------------------------------
uint16_t Update_CRC (uint16_t crc, uint8_t newbyte)
{
   uint8_t i;                               // loop counter

   #define POLY 0x8408                 // CRC16-CCITT FCS (X^16+X^12+X^5+1)

   crc = crc ^ newbyte;

   for (i = 0; i < 8; i++)
   {
      if (crc & 0x01)
      {
         crc = crc >> 1;
         crc ^= POLY;
      }
      else
      {
         crc = crc >> 1;
      }
   }
   return crc;
}

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------
