//-----------------------------------------------------------------------------
// F50x_Main.h - CAN_BL - Target_BL_FW
//-----------------------------------------------------------------------------
// Copyright (C) 2009 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This program performs as the Target Bootloader Firmware for the CAN bootloader.
// PC (Data Source) <--> UART <--> MCU (Master) <--> CAN <--> MCU (Target)
//
//
// Target:         C8051F500 (Side A of a C8051F500-TB)
// Tool chain:     Keil C51 8.0 / Keil EVAL C51
// Command Line:   None
//
//
// Release 1.0 / 18NOV2009 (PKC)
//    -Initial Revision
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Header File Preprocessor Directive
//-----------------------------------------------------------------------------
#ifndef F50X_MAIN_H
#define F50X_MAIN_H

//-----------------------------------------------------------------------------
// Global CONSTANTS
//-----------------------------------------------------------------------------

// InfoBlock defines
#define TGT_BL_FW_VERSION_HIGH 0x00
#define TGT_BL_FW_VERSION_LOW  0x01

// Customize for each node:
#define CAN_DEVICE_ADDR        0x01
#define FLASH_C2_ACCESS_LOCK_BYTE 0xFF // 0xFF = Unlocked

#define TGT_BL_INFOBLOCK_LENGTH  16
#define TGT_APP_INFOBLOCK_LENGTH 7

#define TGT_MCU_CODE             0x21  // Code for this MCU partnumber
#define TGT_BL_TYPE              0x02  // CAN BL
#define TGT_FLASH_PAGE_SIZE_CODE 0x01  // Flash Page Size Code: 1 => 512 bytes

#define TGT_BL_BUFFER_SIZE_CODE  0x08  // BL Buffer Size Code: 8 => 8 bytes
#define TGT_CRC_TYPE             0x01  // CRC Type = CRC-16-CCITT
#define TGT_ENCRYPTION_TYPE      0x00  // None

// Other defines
#define TGT_FLASH_SIZE     (63*1024)   // Flash size of this MCU (1k Reserved)

#define APP_START_ADDR     0x0400
#define APP_LAST_PAGE_START_ADDR (TGT_FLASH_SIZE-PAGE_SIZE-PAGE_SIZE)
#define APP_LAST_PAGE_END_ADDR (APP_LAST_PAGE_START_ADDR+PAGE_SIZE-1)

/*****************************************
Target App FW InfoBlock Format
Byte offset (from last byte) - Field
0 = APP_LAST_PAGE_END_ADDR

0	Signature Byte Low (0) (sig bytes are added by the bootloader after successful programming)
-1	Signature Byte (1)
-2	Signature Byte (2)
-3	Signature Byte High (3)
-4	InfoBlock Length = 7 (for CAN BL; count includes this length byte)
-5	MCU Code
-6	BL Type
-7	Flash Page Size Code
-8	Application FW Version Low (0)
-9	Application FW Version High (1)
-10	BL-specific byte (0) - CAN Device Addr - Not used for read by FW (only present for hex file image)
*****************************************/
#define APP_INFOBLOCK_STARTADDR (APP_LAST_PAGE_END_ADDR-4)

#define SIG_BYTE0_ADDR  (APP_LAST_PAGE_END_ADDR)
#define SIG_BYTE1_ADDR  (APP_LAST_PAGE_END_ADDR-1)
#define SIG_BYTE2_ADDR  (APP_LAST_PAGE_END_ADDR-2)
#define SIG_BYTE3_ADDR  (APP_LAST_PAGE_END_ADDR-3)

// Bit masks for the RSTSRC SFR
#define PORSF  0x02
#define FERROR 0x40

// LED State Values
#define LED_OFF         0x00
#define LED_ON          0x01
#define LED_BLINK_SLOW  0x02
#define LED_BLINK_FAST  0x03

// Flash Write/Erase Key Codes for Target MCU
#define FLASH_KEY0   0xA5
#define FLASH_KEY1   0xF1

// Device Mode
#define MODE_BL_NO_APP  0x01  // Bootload mode, no app or invalid app signature
#define MODE_APP        0x02
#define MODE_BL_PIN_REQ 0x03  // Bootload mode, requested by pin override
#define MODE_BL_APP_REQ 0x04  // Bootload mode, requested by App FW

// App_FW_Valid states
#define INVALID      0x00
#define VALID        0x01

//Bootloader Pin Override
#define BOOTLOADER_PIN_OVERRIDE  // Comment this out to disable this feature
//-----------------------------------------------------------------------------
// Global Variables - Externs
//-----------------------------------------------------------------------------
extern uint8_t App_FW_Valid;

extern uint16_t Page_Addr;
extern uint16_t Page_Index;
extern uint8_t Flash_Key_Code0;
extern uint8_t Flash_Key_Code1;
extern uint8_t Command_Code;
extern uint8_t LED_State;

extern uint8_t Rx_CAN_Device_Addr;

// This one is defined in ...InfoBlock.c:
SI_SEGMENT_VARIABLE(TGT_BL_InfoBlock[], extern const uint8_t, SI_SEG_CODE);

//-----------------------------------------------------------------------------
// Function Prototypes
//-----------------------------------------------------------------------------
extern void START_APPLICATION(void);   // Function prototype for app's Reset
                                       // vector entry point
                                       // Defined in F50x_Target_BL_Startup.A51

//-----------------------------------------------------------------------------
// Header File Preprocessor Directive
//-----------------------------------------------------------------------------
#endif

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------
