//-----------------------------------------------------------------------------
// F50x_Target_BL_InfoBlock.c - CAN_BL - Target_BL_FW
//-----------------------------------------------------------------------------
// Copyright (C) 2009 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This file contains a set of bytes that will be placed as the last bytes of
// the target BL FW (ending at the lock byte). The locating is done by
// using the linker command line.
//
// Locate starting at address (63*1024-16-1) = 0xFBEF
//
// Target:         C8051F500
// Tool chain:     Keil C51 8.0 / Keil EVAL C51
// Command Line:   None
//
//
// Release 1.0 / 18NOV2009 (PKC)
//    -Initial Revision
//
//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------
#include "si_toolchain.h"
#include "C8051F500_defs.h"

#ifdef MASTER_MCU_BL
   #undef MASTER_MCU_BL
#endif
#include "F50x_Master_Interface.h"

#include "F50x_Main.h"

//-----------------------------------------------------------------------------
// Global Variables
//-----------------------------------------------------------------------------

/*****************************************
Target Bootloader InfoBlock Format
Byte offset (from last byte) - Field

*  Flash C2 Access Lock Byte (not counted in InfoBlock length)
0  InfoBlock Length = 16 (for CAN BL; count includes this length byte)
-1  Bootloader FW Version Low (0)
-2  Bootloader FW Version High (1)
-3  MCU Code
-4  BL Type
-5  Flash Page Size Code
-6  BL Buffer Size Code
-7  CRC Type
-8  Encryption Type
-9  Application FW Start Addr Low (0)
-10 Application FW Start Addr (1)
-11 Application FW Start Addr High (2)
-12 Application FW End Addr Low (0)
-13 Application FW End Addr (1)
-14 Application FW End Addr High (2)
-15 BL-Specific Byte (0) - CAN Device Addr
*****************************************/

/*
SI_SEGMENT_VARIABLE(TGT_BL_InfoBlock[], const uint8_t, SI_SEG_CODE) =
{
   FLASH_C2_ACCESS_LOCK_BYTE,
   16,
   TGT_BL_FW_VERSION_LOW,
   TGT_BL_FW_VERSION_HIGH,
   TGT_MCU_CODE,
   0x02, // BL Type = CAN
   0x01, // Flash Page Size Code: 1 => 512 bytes
   0x08, // BL Buffer Size Code: 8 => 8 bytes
   0x01, // CRC Type = CRC-16-CCITT
   0x00, // Encryption Type = None
   (APP_START_ADDR & 0xFF),
   ((APP_START_ADDR & 0xFF00) >> 8),
   0x00,
   (APP_LAST_PAGE_END_ADDR & 0xFF),
   ((APP_LAST_PAGE_END_ADDR & 0xFF00) >> 8),
   0x00,
   CAN_DEVICE_ADDR  // CAN Device Address
}
*/

// Reverse byte order for Keil:
SI_SEGMENT_VARIABLE(TGT_BL_InfoBlock[], const uint8_t, SI_SEG_CODE) =
{
   CAN_DEVICE_ADDR,  // CAN Device Address
   0x00,
   ((APP_LAST_PAGE_END_ADDR & 0xFF00) >> 8),
   (APP_LAST_PAGE_END_ADDR & 0xFF),
   0x00,
   ((APP_START_ADDR & 0xFF00) >> 8),
   (APP_START_ADDR & 0xFF),
   TGT_ENCRYPTION_TYPE,
   TGT_CRC_TYPE,
   TGT_BL_BUFFER_SIZE_CODE,
   TGT_FLASH_PAGE_SIZE_CODE,
   TGT_BL_TYPE,
   TGT_MCU_CODE,
   TGT_BL_FW_VERSION_HIGH,
   TGT_BL_FW_VERSION_LOW,
   TGT_BL_INFOBLOCK_LENGTH,
   FLASH_C2_ACCESS_LOCK_BYTE
};


//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------