//-----------------------------------------------------------------------------
// F50x_Target_Interface.c - CAN_BL - Target_BL_FW
//-----------------------------------------------------------------------------
// Copyright (C) 2009 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This is to be included in Target App FW project.
//
//
// Target:         C8051F500 (Side A of a C8051F500-TB)
// Tool chain:     Keil C51 8.0 / Keil EVAL C51
// Command Line:   None
//
//
// Release 1.0 / 18NOV2009 (PKC)
//    -Initial Revision
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------
#include "si_toolchain.h"
#include "C8051F500_defs.h"

#include "F50x_Target_Interface.h"


//-----------------------------------------------------------------------------
// Global CONSTANTS
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// Global Variables
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Function Prototypes (Local)
//-----------------------------------------------------------------------------

//=============================================================================
// Function Definitions
//=============================================================================

//-----------------------------------------------------------------------------
// CAN0_Init_For_BL_Support
//-----------------------------------------------------------------------------
//
// Return Value : None
// Parameters   : None
//
// This function initializes the CAN peripheral for one receive message object.
//
//-----------------------------------------------------------------------------

void CAN0_Init_For_BL_Support (void)
{
   // SFR page store/restore is not done here because this
   // will be called only from within the CAN0_Init of the Target App FW

   //---------Initialize settings for Receive Message Object

   // Command Mask Register
   CAN0IF1CM = 0x00F0;                 // Write Operation
                                       // Transfer ID Mask, MDir, MXtd
                                       // Transfer ID, Dir, Xtd, MsgVal
                                       // Transfer Control Bits
                                       // Don't set TxRqst or transfer data

   // Mask Registers
   CAN0IF1M1 = 0x0000;                 // Mask Bits 15-0 not used for filtering
   CAN0IF1M2 = 0x5FFC;                 // Ignore Extended Identifier for
                                       // filtering
                                       // Used Direction bit for filtering
                                       // Use ID bits 28-18 for filtering

   // Arbitration Registers
   CAN0IF1A1 = 0x0000;                 // 11-bit ID, so lower 16-bits not used

   // Message Control Registers
   CAN0IF1MC = 0x1480 | BL_MESSAGE_SIZE;  // Enable Receive Interrupt
                                       // Message Object is a Single Message
                                       // Message Size set by #define
   // Arbitration Registers
   CAN0IF1A2 = 0x8000 | (MSG_ID_RX_BL_CMD << 2);   // Set MsgVal to valid
                                                   // Set Object Direction to read
                                                   // Set 11-bit Identifier

   CAN0IF1CR = MO_RX_BL_CMD;              // Start command request

   while (CAN0IF1CRH & 0x80) {}           // Poll on Busy bit
}

//-----------------------------------------------------------------------------
// CAN0_SendMessage
//-----------------------------------------------------------------------------
//
// Return Value : None
// Parameters   : None
//
// Checks if an addressed BL command was received.
//
//-----------------------------------------------------------------------------
uint8_t Check_BL_Command (uint8_t status, uint8_t Interrupt_ID)
{
   // SFR page store/restore is not done here because this
   // will be called only from within the CAN0_ISR

   uint8_t rx_data;

   if ((status & RxOk) && (Interrupt_ID == MO_RX_BL_CMD))
   {
      rx_data = CAN0IF1DA1H; // Read the 1st data byte (command)
      if (rx_data == TGT_CMD_ENTER_BL_MODE)
      {
         rx_data = CAN0IF1DA1L; // Read the 2nd data byte (CAN device addr)

         // Read CAN_Device_Addr from location within bootloader space
         if (rx_data == *(uint8_t code *)(CAN_DEVICE_ADDR_LOCATION))
         {
            // If matched, then enter BL mode
            rx_data = Enter_BL_Mode ();
         }
      }
   }

   // This is just to prevent the compiler from optimizing out the
   // assignment from Enter_BL_Mode
   return rx_data;
}

//-----------------------------------------------------------------------------
// Enter_BL_Mode
//-----------------------------------------------------------------------------
//
// Return Value : None
// Parameters   : None
//
// This function will cause a Flash Error Reset to enter BL mode.
//
//-----------------------------------------------------------------------------
uint8_t Enter_BL_Mode (void)
{
   // The return value is just to prevent the compiler from optimizing out
   // the code read

   return *(uint8_t code*)(RESERVED_SPACE_ADDR);
}

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------
