/**************************************************************************//**
 * @file
 * @brief Energy Modes Exercise Support Function
 * @author Energy Micro AS
* @version 1.10
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2012 Energy Micro AS, http://www.energymicro.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 * 4. The source and compiled code may only be used on Energy Micro "EFM32"
 *    microcontrollers and "EFR4" radios.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Energy Micro AS has no
 * obligation to support this Software. Energy Micro AS is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Energy Micro AS will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 *****************************************************************************/
#include "efm32.h"
#include "em_chip.h"
#include "em_emu.h"
#include "em_usart.h"
#include "em_rtc.h"
#include "em_cmu.h"
#include "em_gpio.h"

/* Header file for support functions */
#include "4_exercise.h"

/**************************************************************************//**
 * @brief  Main function
 *****************************************************************************/
int main(void)
{
  /* Chip revision alignment and errata fixes */
  CHIP_Init();

  /* Initialize peripherals */
  usart_setup();
  gpio_setup();
  /* The RTC is using LFXO */
  rtc_setup();

  /* Disable interrupts  */
  NVIC_DisableIRQ(RTC_IRQn);
#if defined(_EFM32_GIANT_FAMILY)
  NVIC_DisableIRQ(GPIO_ODD_IRQn);
#else
  NVIC_DisableIRQ(GPIO_EVEN_IRQn);
#endif
  NVIC_DisableIRQ(USART1_TX_IRQn);


  /* Enable RTC interrupts - produces an interrupt every second */
  NVIC_EnableIRQ(RTC_IRQn);


  /* Enter the lowest possible energy mode here */
  EMU_EnterEM2(true);


  /* Disable RTC interrupts */
  NVIC_DisableIRQ(RTC_IRQn);


  /* Enter the lowest possible energy mode here */
  /* answer: EM0 which we already are in */

  /* Do some computations */
  uint32_t mult[10][10];
  for (uint32_t i = 0; i < 10; i++)
  {
    for (uint32_t j = 0; j < 10; j++)
    {
      mult[i][j] = (i + 1) * (j + 1);
    }
  }


  /* Enable USART interrupts */
  NVIC_EnableIRQ(USART1_TX_IRQn);

  /* Send a byte with the UART - produces an interrupt when done */
  USART1->TXDATA = mult[0][6] + '0';


  /* Enter the lowest possible energy mode here */
  EMU_EnterEM1();


  /* Disable USART interrupts */
  NVIC_DisableIRQ(USART1_TX_IRQn);

  /* Enable GPIO interrupts - produced when Push Button 0 is pressed */
#if defined(_EFM32_GIANT_FAMILY)
  NVIC_EnableIRQ(GPIO_ODD_IRQn);
#else
  NVIC_EnableIRQ(GPIO_EVEN_IRQn);
#endif


  /* Enter the lowest possible energy mode here */
  EMU_EnterEM3(true);


 /* Disable GPIO */
#if defined(_EFM32_GIANT_FAMILY)
  NVIC_DisableIRQ(GPIO_ODD_IRQn);
#else
  NVIC_DisableIRQ(GPIO_EVEN_IRQn);
#endif

  /* Enter the lowest possible energy mode here */
  EMU_EnterEM4();


  /* Stay in the loop forever */
  while (1) ;
}