//
// Copyright (c) 2013 SILICON LABORATORIES, INC.
//
// FILE NAME   : main.c
// TARGET MCU  : C8051F380
// DESCRIPTION : ARM Debug Interface for a 32-bit Programmer
//
// This program demonstrates the basic Serial Wire interface functionality.
// It does not include the procedures to write, erase, or read flash. 
//
// NOTES:
// 1) Remove J15 from the 'F38x Target Board.
// 2) Connect SWDIO (P1.1), SWCLK (P1.3), and ground to the 10-pin CoreSight 
//    connector of an SiM3U/C/L.
// 3) Run the code and observe that transfer_data contains the correct IDCODE
//    to validate the SW interface.
// 
//

#include <compiler_defs.h>
#include <C8051F380_defs.h>
#include "32bit_prog_defs.h"
#include "Init.h"

//-----------------------------------------------------------------------------
// Variables Declarations
//-----------------------------------------------------------------------------

// Debug Port (DP) type. Tracks the type of the current DP connection.
U8 DP_Type;

// Possible values for DP_Type.
enum { DP_TYPE_NONE, DP_TYPE_SWD };


//-----------------------------------------------------------------------------
// main()
//-----------------------------------------------------------------------------
void main(void)
{
   U32 transfer_data[1];

   WDT_Init();
   Oscillator_Init();
   Port_Init();

   // These pins are grounded on the CoreSight debug connector
   P1_4 = 0;
   P1_2 = 0;

   // There is no debug port connection at this point
   DP_Type = DP_TYPE_NONE;

   SWD_Initialize();
   SWD_Configure(DP_TYPE_SWD);
   SWD_Connect();

   transfer_data[0] = 0x00000000;

   // Read the IDCODE from the connected device
   SWD_DAP_Move(1, DAP_IDCODE_RD, &transfer_data);

   // The return value from DAP_IDCODE_RD for SiM3U1xx devices is 0x2BA01477

   // Write the CTRLSTAT register to enable the debug hardware
   transfer_data[0] = 0x50000000;
   SWD_DAP_Move(1, DAP_CTRLSTAT_WR, &transfer_data);

   SWD_Disconnect();

   while (1)
   {
   }
}

//-----------------------------------------------------------------------------
// Initialization
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Subroutines
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// DBG_Reset
//-----------------------------------------------------------------------------
//
// This function returns all debug pins to a neutral state:
//   1. Disconnects from the target.
//   2. Resets all I/O pins.
//
//
void DBG_Reset(void)
{
   SWD_Connect();

   // Reset all I/O ports
   Port_Init();

    // We are disconnecting, so release nSRST
    _ReleaseTargetReset;
}

