/**************************************************************************//**
 * @brief Implementation specific functions for HRM code
 * @version 3.20.3
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2014 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/
#ifndef ACCEL_SYS_OUT
#define ACCEL_SYS_OUT
#include "em_gpio.h"
#define ADXL345				1
#define BMA255				2
#define ACCEL_DEVICE		BMA255		// Select which accelerometer

#if (ACCEL_DEVICE == ADXL345)
#define ACCEL_I2C_ADDR  	0x1d
#define ACCEL_ID			0xe5
#endif

#if (ACCEL_DEVICE == BMA255)
#define ACCEL_I2C_ADDR  	0x18
#define ACCEL_ID			0xFA    //BMA255

#define ACCEL_FIFO_LEVEL	24	// number of 6-byte frame
#define ACCD_X_LSB			0x02
#define ACCD_X_MSB			0x03
#define ACCD_Y_LSB			0x04
#define ACCD_Y_MSB			0x05
#define ACCD_Z_LSB			0x06
#define ACCD_Z_MSB			0x07

#endif
typedef struct AccelPortConfig
{
  uint8_t i2cAddress;
  GPIO_Port_TypeDef irqPort;
  int irqPin;
  I2C_TypeDef *i2c;
}AccelPortConfig_t;

int16_t AccelInit(void *port, int options, void **accel_handle);
int16_t AccelProcessIrq(void* accel_handle, uint16_t timestamp);
int16_t Accel_ReadAccelDataFromDevice(void *accel_handle, int16_t *accel_x, int16_t *accel_y, int16_t *accel_z);
//int16_t AccelWriteToRegister(void* accel_handle, uint8_t address, uint8_t data);
int16_t AccelWriteToRegister(void* accel_handle, uint8_t address, uint8_t data, bool blocking);
int16_t AccelBlockRead(void * accel_handle, uint8_t address, uint8_t length, uint8_t *values);
int16_t AccelReadFromRegister(void *accel_handle, uint8_t address, uint8_t blocking);


#endif

