#ifndef SI117X_SYS_OUT
#define SI117X_SYS_OUT

#ifdef __cplusplus
extern "C" {
#endif

/* Communicate with the Si117x over I2C or SPI. SPI is only compatible with the Si117x */
#define SI117X_I2C  0
#define SI117X_SPI  1
#define SI117X_BUS  SI117X_I2C

#include <stdint.h>
#include "em_gpio.h"   //needed for GPIO_Port_TypeDef
#include "si117xdrv.h"

#if (SI117X_BUS == SI117X_I2C)
  #include "em_i2c.h"
#elif (SI117X_BUS == SI117X_SPI)
  #include "spidrv.h"
#endif



typedef struct Si117xPortConfig
{
#if (SI117X_BUS == SI117X_I2C)
  I2C_TypeDef       *i2cPort;   /**< I2C port Si117x is connected to */
  uint8_t           i2cAddress; /**< I2C address of Si117x */
#elif (SI117X_BUS == SI117X_SPI)
  SPIDRV_Handle_t   spiHandle;   /**< SPI Handle Si117x is connected to */
  SPIDRV_Init_t     *spiPortConfig;  /**< SPIDRV Initialization struct. */

#endif
  GPIO_Port_TypeDef irqPort;    /**< Port for Si117x INT pin */
  int               irqPin;     /**< Pin for Si117x INT pin */
} Si117xPortConfig_t;




#define  SI117X_SYS_OUT_SUCCESS  0

int16_t Si117xInit(void *port, int options, HANDLE *si117x_handle);
HANDLE GetCurrentHandle(void);
void Si117xEnableInterrupt(void);
void Si117xDisableInterrupt(void);
void delay_10ms();
void delay_ms();

/* Definitions for transmission length */
#if (SI117X_BUS == SI117X_SPI)
  #define WRITE_BUFFER_LENGTH 2
  #define READ_BUFFER_LENGTH 2
#endif

#ifdef __cplusplus
}
#endif

#endif
