#include <stdio.h>
#include "si117x_sys_out.h"

#include "string.h"
#include "si117x_functions.h"



HANDLE mcu_handle;

typedef struct
{	HANDLE device_handle;
	HANDLE board_handle;
	HANDLE device0_handle;
}Si117xSYSOUT_DATA, *Si117xSYSOUT_HANDLE;





/*  Critical Sections in this code are meant to prevent I2C or SPI collisions. If bus transactions occur
 *  inside an interrupt context then collisions can occur.  In this case, the code should disable any
 *  interrupts in which a collision may occur.  The "safe" thing to do is to ensure that bus transactions
 *  never occur in the interrupt context.  In this case critical sections are not needed.
 */
#define SI117X_USE_CRITICAL_SECTIONS  0

#if (SI117X_USE_CRITICAL_SECTIONS == 1)
	void Si117xEnterCriticalSection(void)
	{
	   /*  add code here to disable any interrupts that may impact this section
	    *  typically this is any interrupt in which an I2C or SPI transaction may occur
	    */

	}

	void Si117xExitCriticalSection(void)
	{
		   /*  add code here to re-enable any interrupts that may impact this section
		    *  typically this is any interrupt in which an I2C or SPI transaction may occur
		    *  Be careful not to accidently enable interrupts that were not previously disabled
		    */

	}

#else
  #define Si117xEnterCriticalSection()     //Do nothing
  #define Si117xExitCriticalSection()      //Do nothing
#endif



/**************************************************************************//**
 * @brief Write to Si117x register
 *****************************************************************************/
int32_t Si117xWriteToRegister(HANDLE si117x_handle, uint8_t address, uint8_t data)
{
	return -1;
}

/**************************************************************************//**
 * @brief Read from Si117x register.
 *****************************************************************************/
int32_t Si117xReadFromRegister(HANDLE si117x_handle, uint8_t address)
{
	return -1;
}

/**************************************************************************//**
 * @brief block write to si117x
 * Block writes should never be used.
 *****************************************************************************/
int32_t Si117xBlockWrite(HANDLE si117x_handle,
                     uint8_t address, uint8_t length, uint8_t const *values)
{
	return -1;
}

/**************************************************************************//**
 * @brief Block read from Si117x.
 *****************************************************************************/
int32_t Si117xBlockRead(HANDLE si117x_handle,
                    uint8_t address, uint8_t length, uint8_t *values)
{
	return -1;
}

/**************************************************************************//**
 * @brief Disable GPIO interrupt for Si117x interrupt.
 *****************************************************************************/
void Si117xDisableInterrupt (void)
{
}

/**************************************************************************//**
 * @brief Enable GPIO interrupt for Si117x.
 *****************************************************************************/
void Si117xEnableInterrupt (void)
{
}



/**************************************************************************//**
 * @brief Initialize low level handle and clear irq queue.
 *****************************************************************************/
int16_t Si117xInit(void *port, int options, HANDLE *si117x_handle)
{
	return -1;
}


/**************************************************************************//**
 * @brief Close Si117x.
 *****************************************************************************/
int16_t Si117xClose(HANDLE si117x_handle)
{
  return 0;
}




/**************************************************************************//**
 * @brief Hardware implemented delay function. Does not need to be accurate.
 *****************************************************************************/
void delay_ms(int ms) 
{
}

/**************************************************************************//**
 * @brief 10ms delay required by Si117x reset sequence.
 *****************************************************************************/
void delay_10ms(void)
{
}




