/***************************************************************************//**
 * @file
 * @brief Driver for Si117x skin detection
 * @version 0.0.1
 *******************************************************************************
 * @section License
 * <b>Copyright 2016 Silicon Labs, Inc. http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#ifndef SI117XSKINDETECTION_H
#define SI117XSKINDETECTION_H

/*******************************************************************************
 *******************************   DEFINES   ***********************************
 ******************************************************************************/

/** Skin detect configuration structure. */
typedef struct 
{
  uint16_t measrate;
  uint8_t meascount;
  uint8_t ppg4_led1_config;
  uint8_t ppg4_led2_config;
  uint8_t ppg4_led3_config;
  uint8_t ppg4_led4_config;
  uint8_t ppg4_meas_config;
  uint8_t ppg4_threshold;
  uint8_t ppg4_mode;
  uint8_t ppg4_adcconfig;
} si117xhrmPPGSkinDetectConfig;

/** Si117xO2 config to use IR LED */
#define SI117XHRM_DEFAULT_PPG_SKIN_DETECT_CONFIG_6_IR  \
   {   0x4e20,                                        \
       0x1,                                        \
     0x18,                                        \
     0x18,                                        \
     0x18,                                        \
     0x58,                                        \
     0x03,                                        \
     0x20,                                        \
     0x0F,                                        \
     0x70,                                        \
   }


/** Si117xO2 config to use green LED */
#define SI117XHRM_DEFAULT_PPG_SKIN_DETECT_CONFIG_6_GREEN  \
   { 0x4e20,                                      \
     0x1,                                         \
     0x18,                                        \
     0x58,                                        \
     0x18,                                        \
     0x18,                                        \
     0x03,                                        \
     0x20,                                        \
     0x0F,                                        \
     0x70,                                        \
   }

/** Si118x config to use green LED */
#define SI118XHRM_DEFAULT_PPG_SKIN_DETECT_CONFIG_6_GREEN  \
   {   0x4e20,                                        \
       0x1,                                        \
	   0x58,                                        \
	   0x18,                                        \
	   0x18,                                        \
	   0x18,                                        \
	   0x03,                                        \
	   0x20,                                        \
	   0x0F,                                        \
	   0x70,                                        \
   }

   
/** Error codes */
#define SI117XHRM_PPG_SKIN_DETECT_ERROR_NOT_SUPPORTED -1
#define SI117XHRM_PPG_SKIN_DETECT_NO_ERROR             0

/*******************************************************************************
 *****************************   PROTOTYPES   **********************************
 ******************************************************************************/
int32_t si117xhrm_EnablePPGSkinDetection (SI117XDRV_DeviceSelect_t device,si117xhrmPPGSkinDetectConfig *config);
int32_t si117xhrm_DisablePPGSkinDetection (SI117XDRV_DeviceSelect_t device);
int32_t si117xhrm_PPGSkinDetectInterruptHandler(SI117XDRV_DeviceSelect_t device);
int32_t si117xhrm_IsPPGSkinDetected(SI117XDRV_DeviceSelect_t device);
int32_t si117xhrm_ClearPPGSkinDetectStatus(SI117XDRV_DeviceSelect_t device);


#endif /* SI117XSKINDETECTION_H */
