/**************************************************************************//**
 * @brief Draws the graphics on the display
 * @version 4.2.1
 *******************************************************************************
 * @section License
 * <b>(C) Copyright 2015 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#ifndef __GRAPHICS_H
#define __GRAPHICS_H

#include <stdint.h>
#include <stdbool.h>

#ifdef __cplusplus
extern "C" {
#endif

#include "em_i2c.h"

#define DEMO_VERSION "Demo v1.0"


#define XOFFSET_HRM          0
#define XOFFSET_END         80

/*******************************************************************************
 *****************************   PROTOTYPES   **********************************
 ******************************************************************************/
void GRAPHICS_Init(void);
void GRAPHICS_DrawHrm(int16_t displayHeartRateValue, int16_t displayStatus, int16_t hrValid);
void GRAPHICS_DrawSpO2(int16_t displaySpO2Value, int16_t displayStatus, int16_t spo2Valid);
void GRAPHICS_DrawInit (char *demo_version, char *sihrmVersion);
void GRAPHICS_DrawError ( void );
void GRAPHICS_DrawIdle(void);

typedef enum
{
  LCD_HOME,
  LCD_HRM,
  LCD_SPO2
}displayType_t;

#ifdef __cplusplus
}
#endif


#endif /* __GRAHPHICS_H */
