#!/usr/bin/env python

from PIL import Image

im = Image.open("graphics_new2.png")
out = open("background.c","w")

xsize = im.size[0]
ysize = im.size[1]

out.write("#include <stdint.h>\n\n")
out.write("const uint32_t background_xsize = ")
out.write(str(xsize))
out.write(";\n");
out.write("const uint32_t background_ysize = ")
out.write(str(ysize))
out.write(";\n");
out.write("const uint8_t background[")
out.write(str(xsize * ysize / 8))
out.write("] = {")

bitcount = 0
byte = 0
printcomma = False

for y in range(ysize):
  for x in range(xsize):
    if (im.getpixel((x,y))[0] != 255):
      byte = byte + (1 << bitcount)
    bitcount = bitcount + 1
    if bitcount > 7:
      if printcomma:
        out.write(", ")
      else:
        printcomma = True
      out.write(str(byte))
      bitcount = 0
      byte = 0


out.write("};")

out.close()
