#ifndef _SIHRM_DEMO_H
#define _SIHRM_DEMO_H

#include "si117x_types.h"

HANDLE accelHandle;

/* The i2c address for si117x parts*/
#define SI1175_I2C_ADDR  0x70
#define ACCEL_I2C_ADDR   0x18

/* EFR32 MG12 BRD4162A*/
#ifdef EFR32MG12P332F1024GL125
#define I2CSPM_INIT                                                    \
  { I2C0,                      /* Use I2C instance 0 */                        \
    gpioPortC,                 /* SCL port */                                  \
    10,                        /* SCL pin */                                   \
    gpioPortC,                 /* SDA port */                                  \
    11,                        /* SDA pin */                                   \
    14,                        /* Location of SCL */                           \
    16,                        /* Location of SDA */                           \
    0,                         /* Use currently configured reference clock */  \
    400000,     /* Set to standard rate  */                     \
    i2cClockHLRStandard,       /* Set to use 4:4 low/high duty cycle */        \
  }

#define SI117X_INT_PORT         gpioPortC
#define SI117X_INT_PIN          9

#define ACCEL_INT_PORT          gpioPortD
#define ACCEL_INT_PIN           12
#endif

typedef struct devicePortConfig
{
    I2C_TypeDef *i2c;
	uint8_t i2cAddress;
	GPIO_Port_TypeDef irqPort;
	int irqPin;
}devicePortConfig_t;

typedef enum HRMSpO2State
{
   HRM_STATE_IDLE,
   HRM_STATE_NOSIGNAL,
   HRM_STATE_ACQUIRING,
   HRM_STATE_ACTIVE,
   HRM_STATE_INVALID
} HRMSpO2State_t;

#define ACC_RESAMPLED_QUEUE_SIZE	        128
#define Si117xFs                            25           // Sensor Sampling rate
#define Si117xSamplesPerChannel             Si117xFs*3/5 // Samples per channel in FIFO
#define PPG_SAMPLES_PER_SYNC_BUF_SIZE		120
#define ResamplerOutputCountBuf_SIZE		120
#define A_SYNC_AVERAGING					1
#define SLIP_ADJUST_RATE					3
#define FsRatio_MIN		                    0.833
#define FsRatio_MAX		                    1.875
#define SYNC_MARKER_INTERVAL				32*ACCEL_FIFO_LEVEL
#define SI117X_MODE_SELECTION 		        1 	         // 1--Enable Si117x mode selection (power-saving mode or performance mode). 0--Disable.
#define RESAMPLER_RATIO_NOMINAL             31.25/25     // Initialization: FsAccel=31.25Hz, FsResample=25.00Hz.


#endif   //_SIHRM_DEMO_H
