/*-----------------------------------------------------------------------------
*
* Project:        Silicon Labs Si7005 UDP Data Logger
*
* Copyright:      2012 Silicon Labs, Inc. (www.silabs.com)
*
* File Name:      Log.h
*
* Description:    Write and erase the log
*
* Revision History:
*
*   10/08/12  QHS  Initial Release
*
*----------------------------------------------------------------------------*/

#define SAMPLE_SIZE        8
#define PAGE_SIZE          1024
#define BANK_SIZE          32768
#define SAMPLES_PER_BANK   4096
#define MAX_SAMPLE_COUNT   8192

#define BANK_1             0x10
#define BANK_2             0x20
#define BANK_ADDRESS       0x8000

/* Where the next sample will be written */
extern VARIABLE_SEGMENT_POINTER( pLog, U8, SEG_XDATA );

/* The number of samples in the log */
extern U16 SampleCount;

/* Prototypes */
U32  Log_Init( void );
void Log_WriteSample( U32 Timestamp, S16 Temperature, S16 Humidity );
void Log_Erase( void );

