/*-----------------------------------------------------------------------------
*
* Project:        Silicon Labs Si7005 UDP Data Logger
*
* Copyright:      2012 Silicon Labs, Inc. (www.silabs.com)
*
* File Name:      Packet.h
*
* Description:    Send and receive packets using the Data Logger Protocol
*
* Revision History:
*
*   10/08/12  QHS  Initial Release
*
*----------------------------------------------------------------------------*/


/* Requests */
#define REQ_GET_ID                       1
#define REQ_GET_VERSION                  2
#define REQ_GET_STATUS                   3
#define REQ_GET_TEMPERATURE              4
#define REQ_GET_HUMIDITY                 5
#define REQ_GET_TIME                     6
#define REQ_SET_TIME                     7
#define REQ_GET_TIME_ZONE                8
#define REQ_SET_TIME_ZONE                9
#define REQ_GET_SAMPLE_INTERVAL          10
#define REQ_SET_SAMPLE_INTERVAL          11
#define REQ_GET_HIGH_TEMP_THRESHOLD      12
#define REQ_SET_HIGH_TEMP_THRESHOLD      13
#define REQ_GET_LOW_TEMP_THRESHOLD       14
#define REQ_SET_LOW_TEMP_THRESHOLD       15
#define REQ_GET_HIGH_HUMIDITY_THRESHOLD  16
#define REQ_SET_HIGH_HUMIDITY_THRESHOLD  17
#define REQ_GET_LOW_HUMIDITY_THRESHOLD   18
#define REQ_SET_LOW_HUMIDITY_THRESHOLD   19
#define REQ_GET_LOGGING                  20
#define REQ_SET_LOGGING                  21
#define REQ_GET_SAMPLE_COUNT             22
#define REQ_GET_LOG                      23
#define REQ_ERASE_LOG                    24
#define REQ_SET_CONNECTED                25

/* Packet */
typedef struct
{
   U8  Start;
   U8  Request;
   U16 DataLength;
   S32 Parameter;
   U8  Checksum;
} PACKET;

/* Prototypes */
S8 Packet_Receive( VARIABLE_SEGMENT_POINTER(pPacket,PACKET,SEG_IDATA) );
S8 Packet_Send(    VARIABLE_SEGMENT_POINTER(pPacket,PACKET,SEG_IDATA) );
S8 Packet_SendLog( VARIABLE_SEGMENT_POINTER(pPacket,PACKET,SEG_IDATA) );

