//-------------------------------------------------------------------------------
// Copyright (c) 2012 by Silicon Laboratories
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Silicon Laboratories End User
// License Agreement which accompanies this distribution, and is available at
// http://developer.silabs.com/legal/version/v10/License_Agreement_v10.htm
//
//
// Original content and implementation provided by Silicon Laboratories
//-------------------------------------------------------------------------------

//==============================================================================
// WARNING:
//
// This file is auto-generated by AppBuilder and should not be modified.
// Any hand modifications will be lost if the project is regenerated.
//==============================================================================

#include "gI2C0.h"

// Include peripheral access modules used in this file
#include <SI32_I2C_A_Type.h>
#include <si32_device.h>

//==============================================================================
// 2nd Level Interrupt Handlers
//==============================================================================
extern void I2C0_tx_complete_handler(void);
extern void I2C0_rx_complete_handler(void);
extern void I2C0_ack_intr_handler(void);
extern void I2C0_stop_handler(void);
extern void I2C0_start_handler(void);
extern void I2C0_arb_lost_handler(void);
extern void I2C0_timer3_handler(void);

//==============================================================================
// 1st Level Interrupt Handlers
//==============================================================================
void I2C0_IRQHandler()
{
  if (SI32_I2C_A_is_tx_interrupt_pending(SI32_I2C_0))
  {
    I2C0_tx_complete_handler();
  }
  if (SI32_I2C_A_is_rx_interrupt_pending(SI32_I2C_0))
  {
    I2C0_rx_complete_handler();
  }
  if (SI32_I2C_A_is_ack_interrupt_pending(SI32_I2C_0))
  {
    I2C0_ack_intr_handler();
  }
  if (SI32_I2C_A_is_stop_interrupt_pending(SI32_I2C_0))
  {
    I2C0_stop_handler();
  }
  if (SI32_I2C_A_is_start_interrupt_pending(SI32_I2C_0))
  {
    I2C0_start_handler();
  }
  if (SI32_I2C_A_is_arblost_interrupt_pending(SI32_I2C_0))
  {
    I2C0_arb_lost_handler();
  }
  if (SI32_I2C_A_is_timer3_interrupt_pending(SI32_I2C_0))
  {
    I2C0_timer3_handler();
  }
}

//==============================================================================
// Configuration Functions
//==============================================================================
void I2C0_enter_default_mode_from_reset(void)
{
    SI32_I2C_A_enable_module(SI32_I2C_0);
    SI32_I2C_A_disable_slave_mode(SI32_I2C_0);
    SI32_I2C_A_set_scaler_value(SI32_I2C_0, 63);
    SI32_I2C_A_set_timer0_reload(SI32_I2C_0, 1);
    SI32_I2C_A_set_timer1_reload(SI32_I2C_0, 145);
    SI32_I2C_A_set_timer3_reload(SI32_I2C_0, 123);
    SI32_I2C_A_set_extended_data_setup_time(SI32_I2C_0, 1);
    SI32_I2C_A_set_scl_low_period_reload(SI32_I2C_0, 196);
  SI32_I2C_A_enable_tx_interrupt(SI32_I2C_0);
  SI32_I2C_A_enable_rx_interrupt(SI32_I2C_0);
  SI32_I2C_A_enable_ack_interrupt(SI32_I2C_0);
  SI32_I2C_A_enable_stop_interrupt(SI32_I2C_0);
  SI32_I2C_A_enable_start_interrupt(SI32_I2C_0);
  SI32_I2C_A_enable_arblost_interrupt(SI32_I2C_0);
  SI32_I2C_A_enable_timer3_interrupt(SI32_I2C_0);
  NVIC_ClearPendingIRQ(I2C0_IRQn);
  NVIC_EnableIRQ(I2C0_IRQn);
}

