//-------------------------------------------------------------------------------
// Copyright (c) 2012 by Silicon Laboratories
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Silicon Laboratories End User
// License Agreement which accompanies this distribution, and is available at
// http://developer.silabs.com/legal/version/v10/License_Agreement_v10.htm
//
//
// Original content and implementation provided by Silicon Laboratories
//-------------------------------------------------------------------------------

//==============================================================================
// WARNING:
//
// This file is auto-generated by AppBuilder and should not be modified.
// Any hand modifications will be lost if the project is regenerated.
//==============================================================================

#include "gPB.h"

// Include peripheral access modules used in this file
#include <SI32_PBCFG_A_Type.h>
#include <si32_device.h>
#include <SI32_PBSTD_A_Type.h>
#include <SI32_PBGP_A_Type.h>


//==============================================================================
// 2nd Level Interrupt Handlers
//==============================================================================
extern void PMATCH_handler(void);

//==============================================================================
// 1st Level Interrupt Handlers
//==============================================================================
void PMATCH_IRQHandler()
{
    PMATCH_handler();
}

void pb_enter_default_mode_from_reset(void)
{
  SI32_PBCFG_A_disable_jtag(SI32_PBCFG_0);

  // PB0 Setup
  SI32_PBSTD_A_set_pins_digital_input(SI32_PBSTD_0, 0x0002);
  SI32_PBSTD_A_set_pins_push_pull_output(SI32_PBSTD_0, 0x0864);
  SI32_PBSTD_A_write_pbskipen(SI32_PBSTD_0, 0x01FF);
  SI32_PBSTD_A_set_pins_high_drive_strength(SI32_PBSTD_0, 0x0060);

  // PB1 Setup
  SI32_PBSTD_A_set_pins_analog(SI32_PBSTD_1, 0x0F00);
  SI32_PBSTD_A_set_pins_digital_input(SI32_PBSTD_1, 0x007C);
  SI32_PBSTD_A_write_pbskipen(SI32_PBSTD_1, 0x0F00);
  SI32_PBSTD_A_write_pmen(SI32_PBSTD_1, 0x0070);

  // PB3 Setup
  SI32_PBSTD_A_set_pins_analog(SI32_PBSTD_3, 0xFFFF);
  SI32_PBSTD_A_write_pbskipen(SI32_PBSTD_3, 0xFFFF);

  // Enable Crossbar0 signals & set properties
  SI32_PBCFG_A_enable_xbar0_peripherals(SI32_PBCFG_0, SI32_PBCFG_A_XBAR0_I2C0EN);
  SI32_PBCFG_A_enable_crossbar_0(SI32_PBCFG_0);

  // PB4 Setup
  SI32_PBGP_A_set_pins_analog(SI32_PBGP_4, 0xFFFF);
  SI32_PBCFG_A_enable_port_match_interrupt(SI32_PBCFG_0);
  NVIC_ClearPendingIRQ(PMATCH_IRQn);
  NVIC_EnableIRQ(PMATCH_IRQn);
}


