//-------------------------------------------------------------------------------
// Copyright (c) 2012 by Silicon Laboratories
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Silicon Laboratories End User
// License Agreement which accompanies this distribution, and is available at
// http://developer.silabs.com/legal/version/v10/License_Agreement_v10.htm
//
//
// Original content and implementation provided by Silicon Laboratories
//-------------------------------------------------------------------------------

//==============================================================================
// WARNING:
//
// This file is auto-generated by AppBuilder and should not be modified.
// Any hand modifications will be lost if the project is regenerated.
//==============================================================================

#include "gUART0.h"

// Include peripheral access modules used in this file
#include <SI32_UART_B_Type.h>
#include <SI32_PMU_A_Type.h>
#include <si32_device.h>

//==============================================================================
// 2nd Level Interrupt Handlers
//==============================================================================
extern void UART0_tx_data_req_handler(void);
extern void UART0_rx_data_req_handler(void);
extern void UART0_rx_error_handler(void);

//==============================================================================
// 1st Level Interrupt Handlers
//==============================================================================
void UART0_IRQHandler()
{
  if (SI32_UART_B_is_tx_data_request_interrupt_pending(SI32_UART_0))
  {
    UART0_tx_data_req_handler();
  }
  if (SI32_UART_B_is_rx_data_request_interrupt_pending(SI32_UART_0))
  {
    UART0_rx_data_req_handler();
  }
  if (SI32_UART_B_is_rx_overrun_interrupt_pending(SI32_UART_0))
  {
    UART0_rx_error_handler();
  }
  if (SI32_PMU_A_is_uart_wakeup_flag_set(SI32_PMU_0))
  {
    SI32_PMU_A_clear_wakeup_flags(SI32_PMU_0);
  }  
}

//==============================================================================
// Configuration Functions
//==============================================================================
void UART0_enter_default_mode_from_reset(void)
{
    SI32_UART_B_select_rtc_clock_mode(SI32_UART_0);    
    SI32_UART_B_enable_tx_output(SI32_UART_0);
    SI32_UART_B_enable_rx(SI32_UART_0);
    SI32_UART_B_enable_tx(SI32_UART_0);
  SI32_UART_B_enable_rx_data_request_interrupt(SI32_UART_0);
  SI32_UART_B_enable_rx_error_interrupts(SI32_UART_0);
  SI32_UART_B_set_rx_baudrate(SI32_UART_0,SI32_UART_B_RTC_BAUDRATE_9600);
  SI32_UART_B_set_tx_baudrate(SI32_UART_0,SI32_UART_B_RTC_BAUDRATE_9600);
  NVIC_ClearPendingIRQ(UART0_IRQn);
  NVIC_EnableIRQ(UART0_IRQn);
}

