/*-----------------------------------------------------------------------------
*
* Project:        Silicon Labs Si7005 UDP Data Logger
*
* Copyright:      2013 Silicon Labs, Inc. (www.silabs.com)
*
* File Name:      myCPU.c
*
* Description:    Use system tick to impliment elasped time and delay
*
* Revision History:
*
*   02/01/13  QHS  Initial Release
*
*----------------------------------------------------------------------------*/

#include "myCPU.h"
#include <si32_device.h>

void mySystemInit(void)
{
}


/*****************************************************************************/
/* ElapsedTime                                                               */
/*****************************************************************************/

uint32_t ElapsedTime( uint32_t StartTime )
{
   uint32_t CurrentTime = get_msTicks();
   
   if ( CurrentTime >= StartTime )
      return CurrentTime - StartTime;
   else
      return (UINT32_MAX - StartTime) + CurrentTime + 1;
}


/*****************************************************************************/
/* Delay                                                                     */
/*****************************************************************************/

void Delay( uint32_t Milliseconds )
{
   uint32_t StartTime = get_msTicks();
   
   while ( ElapsedTime(StartTime) < Milliseconds );
}

