/*-----------------------------------------------------------------------------
*
* Project:        Silicon Labs Si7005 UDP Data Logger
*
* Copyright:      2013 Silicon Labs, Inc. (www.silabs.com)
*
* File Name:      myLCD0.h
*
* Description:    Liquid crystal display (LCD) driver
*
* Revision History:
*
*   02/01/13  QHS  Initial Release
*
*----------------------------------------------------------------------------*/

#ifndef __MYLCD0_H__
#define __MYLCD0_H__

#include <stdbool.h>

// INCLUDE GENERATED CONTENT
#include "gLCD0.h"

//=============================================================================
// Font map defines
//=============================================================================
//-----------------------------------------------------------------------------
// Segment constants for the VIM-878 LCD
//-----------------------------------------------------------------------------
//
// This section changes if the mapping between LCD segment/driver pins changes.
//
// LCD Segment Constants (Bit Mapping)
// A B C DP    I J K L     H G N M    CA F E D
//-----------------------------------------------------------------------------
#define  SEG_A    0x8000
#define  SEG_B    0x4000
#define  SEG_C    0x2000
#define  SEG_D    0x0001
#define  SEG_E    0x0002
#define  SEG_F    0x0004
#define  SEG_G    0x0040
#define  SEG_H    0x0080
#define  SEG_I    0x0800
#define  SEG_J    0x0400
#define  SEG_K    0x0200
#define  SEG_L    0x0100
#define  SEG_M    0x0010
#define  SEG_N    0x0020
#define  SEG_DP   0x1000
#define  SEG_CA   0x0008

//-----------------------------------------------------------------------------
// Simple Font Table  for 14-segment alpha-numeric displays
//-----------------------------------------------------------------------------
// Numeric
//-----------------------------------------------------------------------------
#define  CHAR_0   (SEG_A|SEG_B|SEG_C|SEG_D|SEG_E|SEG_F|SEG_J|SEG_N)
#define  CHAR_1   (SEG_B|SEG_C)
#define  CHAR_2   (SEG_A|SEG_B|SEG_D|SEG_E|SEG_G|SEG_K)
#define  CHAR_3   (SEG_A|SEG_B|SEG_C|SEG_D|SEG_K)
#define  CHAR_4   (SEG_B|SEG_C|SEG_F|SEG_G|SEG_K)
#define  CHAR_5   (SEG_A|SEG_C|SEG_D|SEG_F|SEG_G|SEG_K)
#define  CHAR_6   (SEG_A|SEG_C|SEG_D|SEG_E|SEG_F|SEG_G|SEG_K)
#define  CHAR_7   (SEG_A|SEG_B|SEG_C)
#define  CHAR_8   (SEG_A|SEG_B|SEG_C|SEG_D|SEG_E|SEG_F|SEG_G|SEG_K)
#define  CHAR_9   (SEG_A|SEG_B|SEG_C|SEG_D|SEG_F|SEG_G|SEG_K)
//-----------------------------------------------------------------------------
// Aplha (capital letters)
//-----------------------------------------------------------------------------
#define  CHAR_A   (SEG_A|SEG_B|SEG_C|SEG_E|SEG_F|SEG_G|SEG_K)
#define  CHAR_B   (SEG_A|SEG_B|SEG_C|SEG_D|SEG_G|SEG_K|SEG_I|SEG_M)
#define  CHAR_C   (SEG_A|SEG_F|SEG_E|SEG_D)
#define  CHAR_D   (SEG_A|SEG_B|SEG_C|SEG_D|SEG_I|SEG_M)
#define  CHAR_E   (SEG_A|SEG_D|SEG_E|SEG_F|SEG_G|SEG_K)
#define  CHAR_F   (SEG_A|SEG_E|SEG_F|SEG_G)
#define  CHAR_G   (SEG_A|SEG_C|SEG_D|SEG_E|SEG_F|SEG_K)
#define  CHAR_H   (SEG_B|SEG_C|SEG_E|SEG_F|SEG_G|SEG_K)
#define  CHAR_I   (SEG_A|SEG_D|SEG_I|SEG_M)
#define  CHAR_J   (SEG_B|SEG_C|SEG_D|SEG_E)
#define  CHAR_K   (SEG_E|SEG_F|SEG_G|SEG_J|SEG_L)
#define  CHAR_L   (SEG_D|SEG_E|SEG_F)
#define  CHAR_M   (SEG_B|SEG_C|SEG_E|SEG_F|SEG_H|SEG_J)
#define  CHAR_N   (SEG_B|SEG_C|SEG_E|SEG_F|SEG_H|SEG_L)
#define  CHAR_O   (SEG_A|SEG_B|SEG_C|SEG_D|SEG_E|SEG_F)
#define  CHAR_P   (SEG_A|SEG_B|SEG_E|SEG_F|SEG_G|SEG_K)
#define  CHAR_Q   (SEG_A|SEG_B|SEG_C|SEG_D|SEG_E|SEG_F|SEG_L)
#define  CHAR_R   (SEG_A|SEG_B|SEG_E|SEG_F|SEG_G|SEG_K|SEG_L)
#define  CHAR_S   (SEG_A|SEG_C|SEG_D|SEG_F|SEG_G|SEG_K)
#define  CHAR_T   (SEG_A|SEG_I|SEG_M)
#define  CHAR_U   (SEG_B|SEG_C|SEG_D|SEG_E|SEG_F)
#define  CHAR_V   (SEG_B|SEG_C|SEG_H|SEG_L)
#define  CHAR_W   (SEG_B|SEG_C|SEG_D|SEG_E|SEG_F|SEG_M)
#define  CHAR_X   (SEG_H|SEG_J|SEG_L|SEG_N)
#define  CHAR_Y   (SEG_H|SEG_J|SEG_M)
#define  CHAR_Z   (SEG_A|SEG_D|SEG_J|SEG_N)
//-----------------------------------------------------------------------------
// Special characters the VIM-878 LCD
//-----------------------------------------------------------------------------
#define CHAR_PERIOD     (SEG_DP)
#define CHAR_APOSTROPHE (SEG_CA)
#define CHAR_PLUS       (SEG_G|SEG_K|SEG_I|SEG_M)
#define CHAR_MINUS      (SEG_G|SEG_K)
#define CHAR_ASTERIX    (SEG_G|SEG_H|SEG_I|SEG_J|SEG_K|SEG_L|SEG_M|SEG_N)
#define CHAR_SLASH      (SEG_N|SEG_J)
#define CHAR_PERCENT    (SEG_C|SEG_F|SEG_G|SEG_H|SEG_J|SEG_K|SEG_L|SEG_N)
//-----------------------------------------------------------------------------
// Special Symbol for LCD test
//-----------------------------------------------------------------------------
#define CHAR_AT_SIGN     (SEG_A|SEG_B|SEG_C|SEG_D|SEG_E|SEG_F|SEG_G|SEG_H|SEG_I|SEG_J|SEG_K|SEG_L|SEG_M|SEG_N)
//-----------------------------------------------------------------------------
#define NUM_ALPHA       26
#define NUM_NUMERIC     10
//-----------------------------------------------------------------------------
// This defines the size of the string container used for the lcd display.
//
// The string must be large enough to include all special characters and the
// terminating nul character.
//
// Worst case for VIM878 is 25 characters.
//
// "'1.'2.'3.'4.'5.'6.'7.'8."
//
// The max is set to 32 to give some margin.
//
//-----------------------------------------------------------------------------
#define  MAX_LCD_STRING    (32)
//-----------------------------------------------------------------------------
// AUTO_CLEAR_DISPLAY will automatically clear the display on a caraige return.
//-----------------------------------------------------------------------------
//#define  AUTO_CLEAR_DISPLAY
//=============================================================================
// Public Function Prototypes (API)
//=============================================================================
void myLCD0_enter_default_config(void);
void myLCD0_enter_off_config(void);
void myLCD0_put_number( int number, int min_width, bool hide_leading_zero );
void myLCD0_put_string (char * string);
void myLCD0_put_char (char c);
//=============================================================================
// end LCD_PUTCHAR_VIM878_H
//=============================================================================

#endif //__MYLCD0_H__
