/*-----------------------------------------------------------------------------
*
* Project:        Silicon Labs Si7005 UDP Data Logger
*
* Copyright:      2013 Silicon Labs, Inc. (www.silabs.com)
*
* File Name:      myRTC0.c
*
* Description:    RTC interrupts once a second to increment system time
*
* Revision History:
*
*   02/01/13  QHS  Initial Release
*
*----------------------------------------------------------------------------*/

#include <SI32_RTC_B_Type.h>
#include <si32_device.h>
#include "main.h"
#include "myRTC0.h"


/* Number of RTC ticks in 1 second */
#define ALARM_TIME  32768


//==============================================================================
// 2nd Level Interrupt Handlers (Called from generated code)
//==============================================================================
void RTC0ALRM_alarm0_handler(void)
{
   /* Clear the RTC interrupt */
   SI32_RTC_B_clear_alarm0_interrupt( SI32_RTC_0 );

   /* Set the RTC event */
   Events |= RTC_EVENT;   
}


/*****************************************************************************/
/* RTC0_ReadTimer                                                            */
/*****************************************************************************/

uint32_t RTC0_ReadTimer( void )
{
   /* Start timer capture */
   SI32_RTC_B_start_timer_capture( SI32_RTC_0 );

   /* Wait for the capture to complete */
   while ( SI32_RTC_B_is_timer_capture_in_progress(SI32_RTC_0) );

   /* Return the captured timer value */
   return SI32_RTC_B_read_setcap( SI32_RTC_0 );
}


/*****************************************************************************/
/* RTC0_ElapsedTime                                                          */
/*****************************************************************************/

uint32_t RTC0_ElapsedTime( uint32_t *pStartTime, uint32_t *pEndTime )
{
   if ( *pEndTime >= *pStartTime )
      return *pEndTime - *pStartTime;
   else
      return (ALARM_TIME - *pStartTime) + *pEndTime + 1;
}

