/*-----------------------------------------------------------------------------
*
* Project:        Silicon Labs Si7005 UDP Data Logger
*
* Copyright:      2013 Silicon Labs, Inc. (www.silabs.com)
*
* File Name:      myTrace.c
*
* Description:    Trace buffer for debugging
*
* Revision History:
*
*   02/01/13  QHS  Initial Release
*
*----------------------------------------------------------------------------*/
 
#include <stdint.h>
#include "myTrace.h"
 

#if TRACE_INCLUDE == 1

uint8_t *pTrace;
uint8_t *pTraceLimit;
uint8_t  TraceBuff[TRACE_BUFF_SIZE];


/*****************************************************************************/
/* TraceReset                                                                */
/*****************************************************************************/

void TraceReset( void )
{
   pTraceLimit = &TraceBuff[TRACE_BUFF_SIZE];
   
   for ( pTrace=TraceBuff; pTrace<pTraceLimit; pTrace++ )
      *pTrace = 0;
      
   pTrace = TraceBuff;      
}


/*****************************************************************************/
/* TraceByte                                                                 */
/*****************************************************************************/

void TraceByte( uint8_t Byte )
{
   *pTrace++ = Byte;
   
   if ( pTrace >= pTraceLimit )
      pTrace = TraceBuff;
}


/*****************************************************************************/
/* TraceWord                                                                 */
/*****************************************************************************/

void TraceWord( uint16_t Word )
{
   TraceByte(  Word     & 0xFF );
   TraceByte( (Word>>8) & 0xFF );
}


/*****************************************************************************/
/* TraceDWord                                                                */
/*****************************************************************************/

void TraceDWord( uint32_t DWord )
{
   TraceWord(  DWord      & 0xFFFF );
   TraceWord( (DWord>>16) & 0xFFFF );
}

#endif

