/*-----------------------------------------------------------------------------
*
* Project:        Silicon Labs Si7005 UDP Data Logger
*
* Copyright:      2012 Silicon Labs, Inc. (www.silabs.com)
*
* File Name:      PacketSample.cs
*
* Description:    The PacketSample class represents a sample in a packet
*
* Revision History:
*
*   10/08/12  QHS  Initial Release
*
*----------------------------------------------------------------------------*/

using System;

namespace Silabs.DataLogger
{
    public class PacketSample
    {
        /* Offsets of fields within a sample */
        private const int offsetTimeStamp = 0;
        private const int offsetTemperature = 4;
        private const int offsetHumidity = 6;

        /* Size constants */
        private const int sizeSample = 8;
        private const int sizeUInt = 4;

        /* Private data members */
        private int OffsetSample;
        private byte[] Buffer;
        private byte[] Field;

        /* Constructor */
        public PacketSample(byte[] Buffer, int OffsetData, int Index)
        {
            this.Buffer = Buffer;
            OffsetSample = OffsetData + (Index * sizeSample);
            Field = new byte[sizeUInt];
        }

        /* TimeStamp property */
        public uint TimeStamp
        {
            get { return GetUInt(OffsetSample + offsetTimeStamp); }
        }

        /* Temperature property */
        public short Temperature
        {
            get { return GetShort(OffsetSample + offsetTemperature); }
        }

        /* Humidity property */
        public short Humidity
        {
            get { return GetShort(OffsetSample + offsetHumidity); }
        }

        /* GetUInt method */
        private uint GetUInt(int Offset)
        {
            for (int x = 0; x < sizeUInt; x++)
                Field[3 - x] = Buffer[Offset + x];
            return BitConverter.ToUInt32(Field, 0);
        }

        /* GetShort method */
        private short GetShort(int Offset)
        {
            Field[0] = Buffer[Offset + 1];
            Field[1] = Buffer[Offset + 0];
            return BitConverter.ToInt16(Field, 0);
        }
    }
}

