/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core;

import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.entity.IBuildConfiguration;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import java.util.Objects;

public class ProjectWithBuildConfigurationId {
    private String projectName;
    private String buildConfigurationId;
    private boolean skipAutoLibrary;

    public ProjectWithBuildConfigurationId() {
    }

    public ProjectWithBuildConfigurationId(IBuildConfigurationDescriptor bconf) {
        this(((IProjectDescriptor)bconf.getParent()).getName(), bconf.getId(), false);
    }

    public ProjectWithBuildConfigurationId(IBuildConfiguration bconf) {
        this(((IProjectEntity)bconf.getParent()).getName(), bconf.getId(), false);
    }

    public ProjectWithBuildConfigurationId(IBuildConfigurationDescriptor bconf, boolean skipAutoLibrary) {
        this(((IProjectDescriptor)bconf.getParent()).getName(), bconf.getId(), skipAutoLibrary);
    }

    public ProjectWithBuildConfigurationId(IBuildConfiguration bconf, boolean skipAutoLibrary) {
        this(((IProjectEntity)bconf.getParent()).getName(), bconf.getId(), skipAutoLibrary);
    }

    public ProjectWithBuildConfigurationId(String projectName, String buildConfigurationId) {
        this(projectName, buildConfigurationId, false);
    }

    private ProjectWithBuildConfigurationId(String projectName, String buildConfigurationId, boolean skipAutoLibrary) {
        this.projectName = projectName;
        this.buildConfigurationId = buildConfigurationId;
        this.skipAutoLibrary = skipAutoLibrary;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getBuildConfigurationId() {
        return this.buildConfigurationId;
    }

    public void setBuildConfigurationId(String buildConfigurationId) {
        this.buildConfigurationId = buildConfigurationId;
    }

    public boolean getSkipAutoLibrary() {
        return this.skipAutoLibrary;
    }

    public void setSkipAutoLibrary(boolean skipAutoLibrary) {
        this.skipAutoLibrary = skipAutoLibrary;
    }

    public int hashCode() {
        return Objects.hash(this.buildConfigurationId, this.projectName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().isAssignableFrom(this.getClass())) {
            return false;
        }
        ProjectWithBuildConfigurationId other = (ProjectWithBuildConfigurationId)obj;
        if (!Objects.equals(this.buildConfigurationId, other.buildConfigurationId)) {
            return false;
        }
        return Objects.equals(this.projectName, other.projectName);
    }

    public String toString() {
        return this.projectName + " - " + this.buildConfigurationId + " - AutoDependency: " + !this.skipAutoLibrary;
    }
}

