/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.engine.BaseProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.CopiedFileReference;
import com.silabs.ss.framework.project.api.core.engine.ICopiedFileReference;
import com.silabs.ss.framework.project.api.core.engine.operations.CopyProjectFileOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.CreateProjectFolderOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.GenerateProjectFileOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IAddToProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.LinkProjectFileOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.LinkProjectFolderOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.RemoveProjectFileOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.RemoveProjectFolderOperation;
import com.silabs.ss.framework.project.api.core.entity.IBuildConfiguration;
import com.silabs.ss.framework.project.api.core.entity.IExternalProjectEntity;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.rcp.core.URIUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class BaseExternalProjectEngineOperationHandler
extends BaseProjectEngineOperationHandler {
    public BaseExternalProjectEngineOperationHandler(IExternalProjectEntity projEntity) {
        super(projEntity);
    }

    protected abstract Collection<ICopiedFileReference> copiedFiles();

    @Override
    public IExternalProjectEntity getProjectEntity() {
        return (IExternalProjectEntity)super.getProjectEntity();
    }

    protected IBuildConfiguration getTargetConfig() {
        IBuildConfiguration bConf = this.getProjectEntity().getCurrentConfiguration();
        if (bConf == null) {
            if (this.getProjectEntity().getBuildConfigurations().length == 0) {
                throw new IllegalStateException("Input project does not have configurations set!");
            }
            bConf = this.getProjectEntity().getBuildConfigurations()[0];
        }
        return bConf;
    }

    protected File getOutputDirectory() {
        File installFile;
        Object mainProject = this.getProjectEntity() == null ? this.getProjectDescriptor() : this.getProjectEntity();
        try {
            installFile = mainProject.getInstallationPath().toFile();
        }
        catch (IOException iOException) {
            installFile = new File(mainProject.getPropertyAccess().getValueString(CoreProperties.INSTALLATION_PATH.id()).replace("file:/", ""));
        }
        if (installFile.isFile() || !installFile.exists() && installFile.getName().contains(".")) {
            return installFile.getParentFile();
        }
        return installFile;
    }

    @Override
    protected void doHandleCopyProjectFileOperation(CopyProjectFileOperation operation, IPath prjPath, IProgressMonitor monitor) throws CoreException {
        if (this.getOutputDirectory() == null) {
            return;
        }
        File srcFile = this.getOperationFile(operation);
        File outputFile = new File(this.getOutputDirectory(), prjPath.toString());
        outputFile.getParentFile().mkdirs();
        if (this.shouldCopyFile(outputFile, srcFile, operation)) {
            try {
                this.handleAddCopiedFileReference(operation.getReference());
                FileUtils.copyFile((File)srcFile, (File)outputFile);
            }
            catch (IOException e) {
                throw Activator.reporter.newCoreException("Failed to copy " + String.valueOf(operation.getContentURI()), (Throwable)e);
            }
        }
        this.registerProjectFile(operation, prjPath, outputFile);
    }

    @Override
    protected void doHandleGenerateProjectFileOperation(GenerateProjectFileOperation operation, IPath prjPath, IProgressMonitor monitor) throws CoreException {
        if (this.getOutputDirectory() == null) {
            return;
        }
        File outputFile = new File(this.getOutputDirectory(), prjPath.toString());
        outputFile.getParentFile().mkdirs();
        if (this.shouldWrite(operation, outputFile)) {
            try {
                this.handleAddCopiedFileReference(operation.getReference());
                FileUtils.writeFileContents((Path)outputFile.toPath(), (String)operation.getFileContent(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw Activator.reporter.newCoreException("Failed to generate file " + String.valueOf(operation.getContentURI()), (Throwable)e);
            }
        }
        this.registerProjectFile(operation, prjPath, outputFile);
    }

    private boolean shouldWrite(GenerateProjectFileOperation operation, File outputFile) {
        if (TextUtils.isEmpty((String)operation.getFileContent())) {
            return false;
        }
        if (!outputFile.isFile()) {
            return true;
        }
        if (!operation.getSelector().isBuiltin()) {
            return false;
        }
        try {
            return !operation.getFileContent().equals(new String(FileUtils.readFileContents((File)outputFile, null)));
        }
        catch (IOException iOException) {
            return true;
        }
    }

    protected abstract void handleAddCopiedFileReference(ICopiedFileReference var1);

    @Override
    protected void doHandleLinkProjectFileOperation(LinkProjectFileOperation operation, IPath prjPath, IProgressMonitor monitor) throws CoreException {
        this.registerProjectFile(operation, prjPath, this.getOperationFile(operation));
    }

    @Override
    protected void doHandleCreateProjectFolderOperation(CreateProjectFolderOperation operation, IPath prjPath, IProgressMonitor monitor) throws CoreException {
        File outputFolder = new File(this.getOutputDirectory(), prjPath.toString());
        this.registerProjectFile(operation, prjPath, outputFolder);
    }

    @Override
    protected void doHandleLinkProjectFolderOperation(LinkProjectFolderOperation operation, IPath prjPath, IProgressMonitor monitor) throws CoreException {
        this.registerProjectFile(operation, prjPath, this.getOperationFile(operation));
    }

    private File getOperationFile(IAddToProjectEngineOperation operation) throws CoreException {
        File srcFile;
        if (operation.getContentFile() != null && operation.getContentFile().isAbsolute()) {
            return operation.getContentFile();
        }
        try {
            srcFile = URIUtils.resolveURIToPath((URI)operation.getContentURI()).toFile();
        }
        catch (IOException e) {
            throw Activator.reporter.newCoreException("cannot access " + String.valueOf(operation.getContentURI()), (Throwable)e);
        }
        return srcFile;
    }

    protected abstract void registerProjectFile(IAddToProjectEngineOperation var1, IPath var2, File var3);

    @Override
    public void handleRemoveProjectFileOperation(RemoveProjectFileOperation operation, IProgressMonitor monitor) throws CoreException {
        String prjPath = ICopiedFileReference.getProjectPath(operation.getProjectPath());
        ICopiedFileReference copiedReference = this.copiedFiles().stream().filter(r -> prjPath.equals(r.getProjectPath())).findAny().orElse(null);
        if (copiedReference == null) {
            return;
        }
        File oldTrash = new File(this.getOutputDirectory(), CopiedFileReference.getPreviousTrashFolderName());
        BaseExternalProjectEngineOperationHandler.renameTrashFolder(oldTrash);
        File copiedFile = new File(this.getOutputDirectory(), prjPath);
        if (!copiedReference.isSameContent(copiedFile)) {
            try {
                this.trashFile(copiedReference, this.getOutputDirectory(), copiedFile);
            }
            catch (IOException e) {
                Activator.reporter.logError("Unable to back up file: " + copiedFile.toString(), (Throwable)e);
                return;
            }
        }
        try {
            if (copiedFile.delete()) {
                this.copiedFiles().remove(copiedReference);
                this.checkFolderDeletion(copiedFile.getParentFile());
            }
        }
        catch (Exception e) {
            Activator.reporter.logError("Unable to delete file: " + copiedFile.toString(), (Throwable)e);
        }
    }

    private void trashFile(ICopiedFileReference copiedReference, File outputDir, File copiedFile) throws IOException {
        if (copiedFile.exists()) {
            Path trashPath = outputDir.toPath().resolve(copiedReference.trashPath());
            Files.createDirectories(trashPath.getParent(), new FileAttribute[0]);
            Files.copy(copiedFile.toPath(), trashPath, new CopyOption[0]);
        }
    }

    @Override
    public void handleRemoveProjectFolderOperation(RemoveProjectFolderOperation operation, IProgressMonitor monitor) throws CoreException {
        String prjPath = operation.getProjectPath().toPortableString();
        File copiedFolder = new File(this.getOutputDirectory(), prjPath);
        this.checkFolderDeletion(copiedFolder);
    }

    private boolean checkFolderDeletion(File copiedFolder) {
        if (copiedFolder.isDirectory() && copiedFolder.list().length == 0) {
            return copiedFolder.delete();
        }
        return false;
    }
}

