/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine;

import com.silabs.java.utils.FileUtils;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.ProjectProperties;
import com.silabs.ss.framework.project.api.core.engine.BaseEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.CopiedFileReference;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.hash.FileContentHashing;
import com.silabs.ss.framework.project.api.core.engine.operations.CopyProjectFileOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.CreateProjectFolderOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.GenerateProjectFileOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.LinkProjectFileOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.LinkProjectFolderOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.ReportErrorOperation;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.core.external.IImportProjectDescriptor;
import com.silabs.ss.framework.project.internal.core.Activator;
import java.io.File;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class BaseProjectEngineOperationHandler
extends BaseEngineOperationHandler
implements IProjectEngineOperationHandler {
    private IProjectEntity projEntity;
    private Set<IPath> touchedResources;

    public BaseProjectEngineOperationHandler(IProjectEntity projEntity) {
        this.projEntity = projEntity;
        this.touchedResources = new HashSet<IPath>();
    }

    @Override
    public IProjectDescriptor getProjectDescriptor() {
        return this.projEntity != null ? (IProjectDescriptor)this.projEntity.getDescriptor() : null;
    }

    @Override
    public IProjectEntity getProjectEntity() {
        return this.projEntity;
    }

    @Override
    public final void handleReportError(ReportErrorOperation operation, IProgressMonitor monitor) throws CoreException {
        Exception except = operation.getException();
        String message = operation.getErrorMsg();
        throw Activator.reporter.newCoreException(message, (Throwable)except);
    }

    @Override
    public final void handleLinkProjectFileOperation(LinkProjectFileOperation operation, IProgressMonitor monitor) throws CoreException {
        IPath prjPath = operation.getProjectPath();
        if (!this.touchedResources.add(prjPath)) {
            return;
        }
        this.doHandleLinkProjectFileOperation(operation, prjPath, monitor);
    }

    protected abstract void doHandleLinkProjectFileOperation(LinkProjectFileOperation var1, IPath var2, IProgressMonitor var3) throws CoreException;

    @Override
    public final void handleLinkProjectFolderOperation(LinkProjectFolderOperation operation, IProgressMonitor monitor) throws CoreException {
        IPath prjPath = operation.getProjectPath();
        if (!this.touchedResources.add(prjPath)) {
            return;
        }
        this.doHandleLinkProjectFolderOperation(operation, prjPath, monitor);
    }

    protected abstract void doHandleLinkProjectFolderOperation(LinkProjectFolderOperation var1, IPath var2, IProgressMonitor var3) throws CoreException;

    @Override
    public void handleCopyProjectFileOperation(CopyProjectFileOperation operation, IProgressMonitor monitor) throws CoreException {
        IPath prjPath = operation.getProjectPath();
        if (!this.touchedResources.add(prjPath)) {
            return;
        }
        this.doHandleCopyProjectFileOperation(operation, prjPath, monitor);
    }

    protected abstract void doHandleCopyProjectFileOperation(CopyProjectFileOperation var1, IPath var2, IProgressMonitor var3) throws CoreException;

    protected boolean shouldCopyFile(File outputFile, File srcFile, CopyProjectFileOperation op) {
        if (outputFile == null) {
            return false;
        }
        if (Objects.equals(srcFile, outputFile)) {
            return false;
        }
        if (outputFile.exists()) {
            boolean shouldOverwrite = (Boolean)this.projEntity.getProperty(ProjectProperties.OVERWRITE_COPIED_SOURCES);
            if (!shouldOverwrite) {
                return false;
            }
            if (srcFile != null && srcFile.canRead()) {
                int source = FileContentHashing.latestHasher().calculateContent(srcFile);
                int existing = FileContentHashing.latestHasher().calculateContent(outputFile);
                return existing == 0 || source != existing;
            }
        }
        if (srcFile != null && srcFile.canRead()) {
            return true;
        }
        return !(op.getSession().getProjectDescriptor() instanceof IImportProjectDescriptor);
    }

    @Override
    public void handleCreateProjectFolderOperation(CreateProjectFolderOperation operation, IProgressMonitor monitor) throws CoreException {
        IPath prjPath = operation.getProjectPath();
        if (prjPath.segmentCount() == 0) {
            return;
        }
        if (!this.touchedResources.add(prjPath)) {
            return;
        }
        this.doHandleCreateProjectFolderOperation(operation, prjPath, monitor);
    }

    protected abstract void doHandleCreateProjectFolderOperation(CreateProjectFolderOperation var1, IPath var2, IProgressMonitor var3) throws CoreException;

    @Override
    public void handleGenerateProjectFileOperation(GenerateProjectFileOperation operation, IProgressMonitor monitor) throws CoreException {
        IPath prjPath = operation.getProjectPath();
        if (prjPath.segmentCount() == 0) {
            return;
        }
        if (!this.touchedResources.add(prjPath)) {
            return;
        }
        this.doHandleGenerateProjectFileOperation(operation, prjPath, monitor);
    }

    protected void doHandleGenerateProjectFileOperation(GenerateProjectFileOperation operation, IPath prjPath, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public Object getValue(String var) {
        if (var.equals("project")) {
            return this.lookupProjectVariable();
        }
        if (var.equals("projectName")) {
            return this.lookupProjectNameVariable();
        }
        return super.getValue(var);
    }

    protected String lookupProjectVariable() {
        return ".";
    }

    protected String lookupProjectNameVariable() {
        return this.projEntity != null ? ((IProjectDescriptor)this.projEntity.getDescriptor()).getName() : "";
    }

    protected static void renameTrashFolder(File oldTrash) {
        if (!oldTrash.exists()) {
            return;
        }
        File oldFile = oldTrash;
        File newFile = new File(oldFile.getParentFile(), CopiedFileReference.getTrashFolderName());
        if (!newFile.exists()) {
            boolean success = oldFile.renameTo(newFile);
            if (!success) {
                Activator.reporter.logError("Failed to rename " + oldTrash.getAbsolutePath() + " to " + CopiedFileReference.getTrashFolderName());
            }
            return;
        }
        try {
            FileUtils.copyTreeNoParent((File)oldFile, (File)newFile, null);
            FileUtils.deleteDirectoryAndContents((File)oldFile);
        }
        catch (Exception ex) {
            Activator.reporter.logException((Throwable)ex);
        }
    }
}

