/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine;

import com.silabs.ss.framework.project.api.core.engine.BaseProjectEngineOperationFactory;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineSession;
import com.silabs.ss.framework.project.api.core.engine.ProjectEngineOperationUtils;
import com.silabs.ss.framework.project.api.core.engine.operations.CreateProjectFolderOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IAddToProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.LinkProjectFileOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.LinkProjectFolderOperation;
import com.silabs.ss.framework.project.api.core.model.MContent;
import com.silabs.ss.framework.project.api.core.model.MFileEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderContent;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.URIUtil;

public class LinkIntoProjectOperationFactory
extends BaseProjectEngineOperationFactory {
    @Override
    public boolean shouldEnter(IProjectEngineSession session, MFolderEntry entry, IAddToProjectEngineOperation folderOperation) {
        return folderOperation instanceof CreateProjectFolderOperation;
    }

    @Override
    public IAddToProjectEngineOperation createAddProjectFolderOperation(IProjectEngineSession session, File containerFile, IPath projectPath, File contentFolder, MFolderEntry entry, MSelectable selector) {
        if (entry instanceof MFolderContent) {
            MFolderContent content = (MFolderContent)entry;
            URI contentURI = ProjectEngineOperationUtils.resolveURI(session, contentFolder, (MContent)content);
            URI projectURI = URIUtil.append((URI)session.getProjectRoot(), (String)projectPath.makeRelative().toPortableString());
            boolean needsLink = projectURI.equals(contentURI) ? false : selector != null && selector.eContainer() instanceof MProject || content.eContainer() instanceof MFolderContent && ((MFolderContent)content.eContainer()).isVirtual() || !contentFolder.getParentFile().equals(containerFile);
            if (needsLink) {
                return new LinkProjectFolderOperation(session, containerFile, projectPath, contentFolder, (MContent)content, selector);
            }
            return new CreateProjectFolderOperation(session, projectPath, contentFolder, (MFolderEntry)content, selector);
        }
        return null;
    }

    @Override
    public IAddToProjectEngineOperation createAddProjectFileOperation(IProjectEngineSession session, File containerFile, IPath projectPath, File contentFile, MFileEntry entry, MSelectable selector) throws IOException {
        IAddToProjectEngineOperation parentOp = super.createAddProjectFileOperation(session, containerFile, projectPath, contentFile, entry, selector);
        if (parentOp != null) {
            return parentOp;
        }
        if (entry instanceof MContent) {
            return new LinkProjectFileOperation(session, containerFile, projectPath, contentFile, (MContent)entry, selector);
        }
        if (contentFile != null) {
            return new LinkProjectFileOperation(session, containerFile, projectPath, contentFile, null, null);
        }
        return null;
    }
}

