/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine;

import com.silabs.ss.framework.project.api.core.engine.BaseProjectEngineOperationFactory;
import com.silabs.ss.framework.project.api.core.engine.CopyIntoProjectOperationFactory;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationFactory;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineSession;
import com.silabs.ss.framework.project.api.core.engine.LinkIntoProjectOperationFactory;
import com.silabs.ss.framework.project.api.core.engine.operations.IAddToProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.model.MContent;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MFileEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;

public class LinkLibrariesIntoProjectOperationFactory
extends BaseProjectEngineOperationFactory {
    protected IProjectEngineOperationFactory linkFactory = new LinkIntoProjectOperationFactory();
    protected IProjectEngineOperationFactory copyFactory = new CopyIntoProjectOperationFactory();

    @Override
    public boolean shouldEnter(IProjectEngineSession session, MFolderEntry entry, IAddToProjectEngineOperation folderOperation) {
        if (this.shouldLink((MEntry)entry)) {
            return this.linkFactory.shouldEnter(session, entry, folderOperation);
        }
        return this.copyFactory.shouldEnter(session, entry, folderOperation);
    }

    @Override
    public IAddToProjectEngineOperation createAddProjectFolderOperation(IProjectEngineSession session, File containerFile, IPath projectPath, File contentFolder, MFolderEntry entry, MSelectable selector) throws IOException {
        if (this.shouldLink((MEntry)entry)) {
            return this.linkFactory.createAddProjectFolderOperation(session, containerFile, projectPath, contentFolder, entry, selector);
        }
        return this.copyFactory.createAddProjectFolderOperation(session, containerFile, projectPath, contentFolder, entry, selector);
    }

    @Override
    public IAddToProjectEngineOperation createAddProjectFileOperation(IProjectEngineSession session, File containerFile, IPath projectPath, File contentFile, MFileEntry entry, MSelectable selector) throws IOException {
        if (this.shouldLink((MEntry)entry)) {
            return this.linkFactory.createAddProjectFileOperation(session, containerFile, projectPath, contentFile, entry, selector);
        }
        return this.copyFactory.createAddProjectFileOperation(session, containerFile, projectPath, contentFile, entry, selector);
    }

    protected boolean shouldLink(MEntry entry) {
        if (entry instanceof MContent && ((MContent)entry).getLinked() != null) {
            return ((MContent)entry).isLinked();
        }
        return this.isLibraryOperation(entry);
    }

    protected boolean isLibraryOperation(MEntry entry) {
        return entry != null && entry.isBuiltin();
    }
}

