/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.variables.IVariableLookup;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.engine.IProjectModelEngineFactory;
import com.silabs.ss.framework.project.api.core.model.MConfigSettings;
import com.silabs.ss.framework.project.api.core.model.MCustomization;
import com.silabs.ss.framework.project.api.core.model.MExclusion;
import com.silabs.ss.framework.project.api.core.model.MFileEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MInclusion;
import com.silabs.ss.framework.project.api.core.model.MModule;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.model.util.manual.ProjectModelLoading;
import com.silabs.ss.framework.project.api.core.modules.IModuleDescriptor;
import com.silabs.ss.framework.project.api.core.modules.Module;
import com.silabs.ss.framework.project.api.core.modules.ModuleProperties;
import com.silabs.ss.framework.project.api.toolchain.core.ToolchainProperties;
import com.silabs.ss.framework.project.internal.api.core.modules.ModuleDescriptor;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.descriptor.core.IWriteableDescriptor;
import com.silabs.ss.platform.api.descriptor.core.IWriteableVersionedDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.descriptor.core.registry.RegistryDescriptorUtils;
import com.silabs.ss.platform.api.sdk.core.SDKProperties;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ProjectModelModuleUtils {
    protected ProjectModelModuleUtils() {
    }

    public static Collection<IModuleDescriptor> loadModulesFromXML(IPath modulesFile) {
        return ProjectModelModuleUtils.loadModulesFromXML(modulesFile, null);
    }

    public static Collection<IModuleDescriptor> loadModulesFromXML(IPath modulesFile, Consumer<IWriteableDescriptor> propSetter) {
        return ProjectModelModuleUtils.loadModulesFromXML(modulesFile.toFile(), propSetter);
    }

    public static Collection<IModuleDescriptor> loadModulesFromXML(File modulesFile, Consumer<IWriteableDescriptor> propSetter) {
        ArrayList<IModuleDescriptor> modules = new ArrayList<IModuleDescriptor>();
        try {
            if (!modulesFile.isFile()) {
                return Collections.emptyList();
            }
            Collection detected = RegistryDescriptorUtils.loadDescriptorsFromFile(ModuleDescriptor.class, (File)modulesFile, (String)"module");
            for (IModuleDescriptor module : detected) {
                IWriteableDescriptor writeable = (IWriteableDescriptor)module;
                String relativePath = module.getPropertyAccess().getValueString(ModuleProperties.CLIENT_MODEL_URI);
                if (relativePath == null || relativePath.isEmpty()) {
                    Activator.reporter.logError("Module client URI file not specified: " + module.getLabel());
                    continue;
                }
                File absolutePath = new File(modulesFile.getParentFile(), relativePath);
                if (!absolutePath.isFile()) {
                    Activator.reporter.logError("Module file not found: " + absolutePath.getAbsolutePath());
                    continue;
                }
                URI pathURI = absolutePath.toURI();
                writeable.setProperty(ModuleProperties.CLIENT_MODEL_URI, (Object)pathURI);
                writeable.setProperty(CoreProperties.INSTALLATION_PATH, (Object)pathURI);
                if (propSetter != null) {
                    propSetter.accept(writeable);
                }
                modules.add(module);
            }
        }
        catch (IOException e) {
            Activator.reporter.logException((Throwable)e);
        }
        return modules;
    }

    public static IModuleDescriptor loadModuleFromSlsproj(File moduleFile, Consumer<IWriteableDescriptor> propSetter) {
        if (!moduleFile.isFile()) {
            return null;
        }
        MProject moduleModel = null;
        try {
            moduleModel = ProjectModelModuleUtils.loadMProjectModel(moduleFile.toURI());
        }
        catch (CoreException e2) {
            Activator.reporter.logException((Throwable)e2);
        }
        if (moduleModel == null) {
            return null;
        }
        IModuleDescriptor module = (IModuleDescriptor)Module.manager().createDescriptor();
        IWriteableVersionedDescriptor wdesc = (IWriteableVersionedDescriptor)module;
        wdesc.setUnversionedId(moduleModel.getId());
        wdesc.setProperty(CoreProperties.PART_COMPATIBILITY.id(), (Object)moduleModel.getPartCompatibility());
        wdesc.setProperty(CoreProperties.BOARD_COMPATIBILITY.id(), (Object)moduleModel.getBoardCompatibility());
        wdesc.setProperty(SDKProperties.SDK_COMPATIBILITY.id(), (Object)moduleModel.getSdkCompatibility());
        wdesc.setProperty(ToolchainProperties.TOOLCHAIN_COMPATIBILITY.id(), (Object)moduleModel.getToolchainCompatibility());
        wdesc.getPropertyAccess().setWarnOnUnknownProperty(false);
        moduleModel.getProperties().forEach(e -> {
            Object object = wdesc.getPropertyAccess().setValue((String)e.getKey(), e.getValue());
        });
        wdesc.getPropertyAccess().setWarnOnUnknownProperty(true);
        return module;
    }

    public static MProject loadMProjectModel(URI uri) throws CoreException {
        return ProjectModelLoading.loadProjectModel((URI)uri);
    }

    public static IProjectModel createModuleModel(MProject project, IVariableLookup variableLookup) throws CoreException {
        ProjectModelModuleUtils.validateNoMultipleFiles(project.getId(), (MFolderEntry)project, null);
        return IProjectModelEngineFactory.INSTANCE.createProjectModel(project, variableLookup);
    }

    private static Set<IPath> validateNoMultipleFiles(String moduleId, MFolderEntry folder, IPath currentPath) throws CoreException {
        HashSet<IPath> pathSet = new HashSet<IPath>();
        if (currentPath == null) {
            currentPath = new Path("");
        }
        if (!TextUtils.isEmpty((String)folder.getName())) {
            currentPath = currentPath.append(folder.getName());
        }
        for (MFileEntry file : folder.getFiles()) {
            IPath filePath = currentPath.append(file.getName());
            if (pathSet.add(filePath) || filePath.toString().contains("$(")) continue;
            throw Activator.reporter.newCoreException("Error: Detected multiple files for the same project path! Module: " + moduleId + " file: " + String.valueOf(filePath));
        }
        for (MFolderEntry fold : folder.getFolders()) {
            Set<IPath> foldSet = ProjectModelModuleUtils.validateNoMultipleFiles(moduleId, fold, currentPath);
            for (IPath filePath : foldSet) {
                if (pathSet.add(filePath) || filePath.toString().contains("$(")) continue;
                throw Activator.reporter.newCoreException("Error: Detected multiple files for the same project path! Module: " + moduleId + " file: " + String.valueOf(filePath));
            }
        }
        return pathSet;
    }

    public static MModule replaceModuleReference(MConfigSettings config, String modId, String ... inclusions) {
        MModule module = ProjectModelModuleUtils.createModule(modId, inclusions);
        ListIterator iter = config.getModules().listIterator();
        while (iter.hasNext()) {
            MModule mod = (MModule)iter.next();
            if (!mod.getId().equals(modId)) continue;
            iter.set(module);
            return module;
        }
        config.getModules().add((Object)module);
        return module;
    }

    public static void addEmptyModule(IProjectModel model, String modId) {
        model.getModel().getModules().add((Object)ProjectModelModuleUtils.createModule(modId, new String[0]));
    }

    public static void addModule(MProject project, String modId, String ... inclusions) {
        ProjectModelModuleUtils.addAndGetModule(project, modId, inclusions);
    }

    public static void addModule(MConfigSettings project, String modId, String ... inclusions) {
        ProjectModelModuleUtils.addAndGetModule(project, modId, inclusions);
    }

    public static MModule addAndGetModule(MProject project, String modId, String ... inclusions) {
        MModule module = ProjectModelModuleUtils.createModule(modId, inclusions);
        project.getModules().add((Object)module);
        return module;
    }

    public static MModule addAndGetModule(MConfigSettings project, String modId, String ... inclusions) {
        MModule module = ProjectModelModuleUtils.createModule(modId, inclusions);
        project.getModules().add((Object)module);
        return module;
    }

    public static MModule createModule(String modId, String ... inclusions) {
        MModule mmodule = ProjectModelFactory.eINSTANCE.createMModule();
        mmodule.setId(modId);
        if (inclusions == null || inclusions.length == 0) {
            MExclusion custom = ProjectModelFactory.eINSTANCE.createMExclusion();
            custom.setPattern(".*");
            mmodule.addCustomization((MCustomization)custom);
        } else {
            String[] stringArray = inclusions;
            int n = inclusions.length;
            int n2 = 0;
            while (n2 < n) {
                String inc = stringArray[n2];
                MInclusion custom = ProjectModelFactory.eINSTANCE.createMInclusion();
                custom.setPattern(inc);
                mmodule.addCustomization((MCustomization)custom);
                ++n2;
            }
        }
        mmodule.setBuiltin(true);
        return mmodule;
    }
}

