/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine;

import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.service.urlconversion.URLConverter;

public class StudioURLConverter
implements URLConverter {
    public static final String PROTOCOL = "studio";
    public static final String TYPE_SDK = "sdk";
    public static final String TYPE_TOOLCHAIN = "toolchain";
    public static final String TYPE_PROJECT = "project";

    public URL toFileURL(URL url) throws IOException {
        throw new IOException("URL " + String.valueOf(url) + " should not be resolved");
    }

    public URL resolve(URL url) throws IOException {
        return this.toFileURL(url);
    }

    public static IPath formatStudioUrl(String type, String filePath) {
        return new Path(StudioURLConverter.formatStudioPath(type, filePath));
    }

    public static String formatStudioPath(String type, String filePath) {
        return PROTOCOL + ":/" + type + "/" + filePath;
    }

    public static String convertToVariable(String uriStr) {
        if (uriStr.startsWith(PROTOCOL)) {
            StringBuilder sb = new StringBuilder("$(");
            String uriSubStr = uriStr.substring(PROTOCOL.length() + 2);
            if (uriSubStr.startsWith(TYPE_SDK)) {
                uriSubStr = uriSubStr.substring(TYPE_SDK.length());
                sb.append("sdkInstallationPath");
            } else if (uriSubStr.startsWith(TYPE_TOOLCHAIN)) {
                uriSubStr = uriSubStr.substring(TYPE_TOOLCHAIN.length());
                sb.append("toolchainInstallationPath");
            } else if (uriSubStr.startsWith(TYPE_PROJECT)) {
                uriSubStr = uriSubStr.substring(TYPE_PROJECT.length());
                sb.append("projectLocation");
            } else {
                return uriStr;
            }
            uriStr = sb.append(")").append(uriSubStr).toString();
        }
        return uriStr;
    }

    public static enum URL_TYPE {
        SDK,
        TOOLCHAIN,
        PROJECT;


        private String typeString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String formatURL(String filePath) {
            return StudioURLConverter.formatStudioPath(this.typeString(), filePath);
        }
    }
}

