/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine.hash;

import com.silabs.java.utils.runtime.RuntimeUtils;
import com.silabs.ss.framework.project.internal.api.core.engine.hash.GuavaFileContentHasher;
import com.silabs.ss.framework.project.internal.api.core.engine.hash.LegacyJavaFileContentHasher;
import java.io.File;

public class FileContentHashing {
    private static final int LATEST_VERSION = 1;
    public static Integer version_override;

    public static int latestVersion() {
        if (RuntimeUtils.isJUnitRunning() && version_override != null) {
            return version_override;
        }
        return 1;
    }

    public static FileContentHasher hasher(int version) {
        if (version == 0) {
            return LegacyJavaFileContentHasher.INSTANCE;
        }
        if (version == 1) {
            return GuavaFileContentHasher.INSTANCE;
        }
        throw new IllegalStateException("Unknown File reference version: " + version);
    }

    public static FileContentHasher latestHasher() {
        return FileContentHashing.hasher(FileContentHashing.latestVersion());
    }

    public static interface FileContentHasher {
        public int calculateContent(File var1);

        public int calculateContent(String var1);
    }
}

