/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.external;

import com.silabs.ss.framework.project.api.core.NewProjectDescriptor;
import com.silabs.ss.framework.project.api.core.adapters.IProjectModelSetupAdapter;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.core.external.IExternalType;
import com.silabs.ss.framework.project.api.core.external.IImportProjectDescriptor;
import com.silabs.ss.framework.project.api.core.external.IProjectReport;
import com.silabs.ss.framework.project.api.core.external.ImportProjectRecord;
import com.silabs.ss.framework.project.api.core.external.report.ProjectImportReport;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMappingRegistry;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchain;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainManager;
import com.silabs.ss.platform.api.content.part.core.IPart;
import com.silabs.ss.platform.api.content.part.core.IPartManager;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptor;
import com.silabs.ss.platform.api.sdk.core.ISDK;
import com.silabs.ss.platform.api.sdk.core.ISDKManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;

public class ImportProjectDescriptor
extends NewProjectDescriptor
implements IImportProjectDescriptor {
    private IExternalType extProjectType;
    private IProjectEntity entity;
    private File inputProject;
    private boolean recreate;
    private String origProjectName;
    private ImportProjectRecord record;
    private IProjectReport report;
    private Collection<IOptionMappingRegistry<?, ?, ?>> mappingRegistries = new ArrayList(1);
    private MProject model;
    private boolean simplify;

    public ImportProjectDescriptor(String projectName, MDescriptor desc) {
        super(projectName, desc);
        this.origProjectName = projectName;
    }

    public ImportProjectDescriptor(String projectName) {
        super(projectName);
        this.origProjectName = projectName;
    }

    @Override
    public IExternalType getExternalProjectType() {
        return this.extProjectType;
    }

    @Override
    public void setExternalProjectType(IExternalType extProjectType) {
        this.extProjectType = extProjectType;
    }

    @Override
    public IProjectEntity getProjectEntity() {
        return this.entity;
    }

    @Override
    public void setProjectEntity(IProjectEntity entity) {
        this.entity = entity;
    }

    @Override
    public File getInputLocation() {
        return this.inputProject;
    }

    @Override
    public void setInputLocation(File file) {
        this.inputProject = file;
    }

    @Override
    public boolean isRecreateConfigurations() {
        return this.recreate;
    }

    @Override
    public void setRecreateConfigurations(boolean recreate) {
        this.recreate = recreate;
    }

    @Override
    public void setSimplify(boolean simplify) {
        this.simplify = simplify;
    }

    @Override
    public boolean isSimplify() {
        return this.simplify;
    }

    @Override
    public Collection<IOptionMappingRegistry<?, ?, ?>> getOptionMappingRegistries() {
        return this.mappingRegistries;
    }

    @Override
    public String convertPath(String path) {
        ISDK sdk = null;
        try {
            sdk = (ISDK)this.getAdapter(ISDKManager.class).get(this.getSdkId());
        }
        catch (CoreException coreException) {}
        IToolchain toolchain = null;
        try {
            toolchain = (IToolchain)this.getAdapter(IToolchainManager.class).get(this.getToolchainId());
        }
        catch (CoreException coreException) {}
        IPart part = null;
        try {
            part = (IPart)this.getAdapter(IPartManager.class).get(this.getPartId());
        }
        catch (CoreException coreException) {}
        IDescriptor[] iDescriptorArray = new IDescriptor[]{sdk, toolchain, part};
        int n = iDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectModelSetupAdapter adapter;
            IDescriptor desc = iDescriptorArray[n2];
            if (desc != null && (adapter = (IProjectModelSetupAdapter)desc.getAdapter(IProjectModelSetupAdapter.class)) != null) {
                path = adapter.convertImportedExternalPath(this, path);
            }
            ++n2;
        }
        return path;
    }

    @Override
    public String getInputProjectName() {
        return this.origProjectName;
    }

    @Override
    public void setInputProjectName(String name) {
        this.origProjectName = name;
    }

    @Override
    public void setImportProjectRecord(ImportProjectRecord record) {
        this.record = record;
    }

    @Override
    public ImportProjectRecord getImportProjectRecord() {
        return this.record;
    }

    @Override
    public IProjectReport getReport() {
        if (this.report == null) {
            this.report = new ProjectImportReport(this);
        }
        return this.report;
    }

    @Override
    public MProject getProjectModel() {
        return this.model;
    }

    @Override
    public void setProjectModel(MProject project) {
        this.model = project;
    }
}

