/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.external;

import com.silabs.java.utils.HostUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.external.IImportProjectDescriptor;
import com.silabs.ss.framework.project.api.core.external.IStringSplitter;
import com.silabs.ss.framework.project.api.core.external.utils.ImporterTool;
import com.silabs.ss.framework.project.api.core.model.ELanguage;
import com.silabs.ss.framework.project.api.core.model.EMappingStatus;
import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.api.core.model.MIncludePath;
import com.silabs.ss.framework.project.api.core.model.MLibraryFile;
import com.silabs.ss.framework.project.api.core.model.MLibraryPath;
import com.silabs.ss.framework.project.api.core.model.MMacroDefinition;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.MToolOption;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.model.options.DirectOptionMappingFactory;
import com.silabs.ss.framework.project.api.core.model.options.GenericOptionMappingFactory;
import com.silabs.ss.framework.project.api.core.model.options.IDirectOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.IGenericOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMappingRegistry;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.rcp.core.IPathUtils;
import com.silabs.ss.platform.api.rcp.core.URIUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProjectImportUtils {
    public static final String LIBRARY_FILE_PATTERN = ".*(:|/|\\\\|\\.).*";

    private ProjectImportUtils() {
    }

    public static IStringSplitter getSemicolonStringSplitter() {
        return s -> s.split(";");
    }

    public static IStringSplitter getCommaStringSplitter() {
        return s -> s.split(",");
    }

    public static IStringSplitter getSemicolonOrCommaStringSplitter() {
        return s -> s.split("(,|;)");
    }

    public static IStringSplitter getMacroCommaStringSplitter() {
        return s -> ProjectImportUtils.splitStringOnlyOutsideQuotes(s, Character.valueOf(','));
    }

    public static IStringSplitter getMacroSemicolonOrCommaStringSplitter() {
        return s -> ProjectImportUtils.splitStringOnlyOutsideQuotes(s, Character.valueOf(','), Character.valueOf(';'));
    }

    public static URI getPlatformProjectURI() {
        return URI.create("studio:/project/");
    }

    public static List<URI> convertStringListToURIList(List<String> stringList) {
        ArrayList<URI> uriList = new ArrayList<URI>();
        for (String uri : stringList) {
            try {
                uriList.add(URIUtils.createAbsoluteURI((String)uri.trim()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return uriList;
    }

    public static List<URI> convertObjectListToURIList(List<Object> objectList) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (Object o : objectList) {
            stringList.add(o.toString());
        }
        return ProjectImportUtils.convertStringListToURIList(stringList);
    }

    public static void removeStringsFromStringList(Collection<String> strings, Collection<String> toRemove) {
        for (String mappedFlag : toRemove) {
            strings.remove(mappedFlag);
        }
    }

    public static void addBuildSettingsToSettingsSite(MSettingsSite site, List<MBuildSetting> buildSettings) {
        for (MBuildSetting setting : buildSettings) {
            if (setting instanceof MMacroDefinition) {
                site.getMacroDefinitions().add((Object)((MMacroDefinition)setting));
                continue;
            }
            if (setting instanceof MIncludePath) {
                site.getIncludePaths().add((Object)((MIncludePath)setting));
                continue;
            }
            if (setting instanceof MLibraryFile) {
                site.getLibraryFiles().add((Object)((MLibraryFile)setting));
                continue;
            }
            if (setting instanceof MLibraryPath) {
                site.getLibraryPaths().add((Object)((MLibraryPath)setting));
                continue;
            }
            if (!(setting instanceof MToolOption)) continue;
            site.getToolOptions().add((Object)((MToolOption)setting));
        }
    }

    public static List<String> splitDirectiveFlags(String flags) {
        int start_index = 0;
        int num_parens = 0;
        boolean prev_was_space = true;
        boolean inside_quotes = false;
        ArrayList<String> flagList = new ArrayList<String>();
        int i = 0;
        while (i < flags.length()) {
            char c = flags.charAt(i);
            if (c == '(' && !inside_quotes) {
                ++num_parens;
                prev_was_space = false;
            } else if (c == ')' && !inside_quotes) {
                --num_parens;
                prev_was_space = false;
            } else if (c == '\"') {
                escaped = false;
                if (i > 0) {
                    boolean bl = escaped = flags.charAt(i - 1) == '\\';
                }
                if (!escaped) {
                    inside_quotes = !inside_quotes;
                }
                prev_was_space = false;
            } else if (c == '\t' || c == ' ') {
                escaped = false;
                if (i > 0) {
                    boolean bl = escaped = flags.charAt(i - 1) == '\\';
                }
                if (!escaped) {
                    prev_was_space = true;
                }
            } else {
                if (prev_was_space && num_parens == 0 && start_index != i && !inside_quotes) {
                    flagList.add(flags.substring(start_index, i).trim());
                    start_index = i;
                }
                prev_was_space = false;
            }
            ++i;
        }
        String lastFlag = flags.substring(start_index, i).trim();
        if (lastFlag.length() > 0) {
            flagList.add(lastFlag);
        }
        return flagList;
    }

    public static List<String> splitHyphenDeliminatedFlags(String flags) {
        ArrayList<String> flagList = new ArrayList<String>();
        int start_index = 0;
        boolean inside_quotes = false;
        boolean prev_was_space = true;
        int i = 0;
        while (i < flags.length()) {
            char c = flags.charAt(i);
            if (c == ' ' || c == '\t') {
                prev_was_space = true;
            } else if (c == '\"') {
                boolean escaped = false;
                if (i > 0) {
                    boolean bl = escaped = flags.charAt(i - 1) == '\\';
                }
                if (!escaped) {
                    inside_quotes = !inside_quotes;
                }
                prev_was_space = false;
            } else if (c == '-') {
                if (prev_was_space && start_index != i && !inside_quotes) {
                    flagList.add(flags.substring(start_index, i).trim());
                    start_index = i;
                }
                prev_was_space = false;
            } else {
                prev_was_space = false;
            }
            ++i;
        }
        String lastFlag = flags.substring(start_index, flags.length()).trim();
        if (lastFlag.length() > 0) {
            flagList.add(lastFlag);
        }
        return flagList;
    }

    public static List<MBuildSetting> createBuildSettingsFromFlags(List<String> flags, URI basePath, String language, Pattern includeArgPattern, IStringSplitter incdirSeparator, Pattern macroArgPattern, IStringSplitter macroSeparator, Pattern libraryPathArgPattern, IStringSplitter libraryPathSeparator, Pattern libraryFileArgPattern, IStringSplitter libraryFileSeparator, IImportProjectDescriptor importDescr, Map<String, String> variables, Pattern variablePattern, Collection<String> unconvertedVariables) {
        ArrayList<MBuildSetting> buildSettings = new ArrayList<MBuildSetting>();
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String flag : flags) {
            List<String> libraries;
            if (includeArgPattern != null) {
                List<String> includeDirs = ProjectImportUtils.patternMatchSplitter(flag, includeArgPattern, incdirSeparator);
                for (String dir : includeDirs) {
                    MIncludePath include = ProjectImportUtils.createMIncludePathFromString(dir, basePath, language, variables, variablePattern, unconvertedVariables);
                    if (include == null) continue;
                    buildSettings.add((MBuildSetting)include);
                    toRemove.add(flag);
                }
            }
            if (macroArgPattern != null) {
                List<String> macros = ProjectImportUtils.patternMatchSplitter(flag, macroArgPattern, macroSeparator);
                for (String macro : macros) {
                    MMacroDefinition mmacro = ProjectImportUtils.createMMacroDefinitionFromString(macro, language, variables, variablePattern, unconvertedVariables);
                    if (mmacro == null) continue;
                    buildSettings.add((MBuildSetting)mmacro);
                    toRemove.add(flag);
                }
            }
            if (libraryPathArgPattern != null) {
                libraries = ProjectImportUtils.patternMatchSplitter(flag, libraryPathArgPattern, libraryPathSeparator);
                for (String lib : libraries) {
                    MLibraryPath mlibraryPath = ProjectImportUtils.createMLibraryPathFromString(lib, basePath, variables, variablePattern, unconvertedVariables);
                    if (mlibraryPath == null) continue;
                    buildSettings.add((MBuildSetting)mlibraryPath);
                    toRemove.add(flag);
                }
            }
            if (libraryFileArgPattern == null) continue;
            libraries = ProjectImportUtils.patternMatchSplitter(flag, libraryFileArgPattern, libraryFileSeparator);
            for (String lib : libraries) {
                MLibraryFile mlibraryFile = ProjectImportUtils.createMLibraryFileFromString(lib, basePath, variables, variablePattern, unconvertedVariables);
                if (mlibraryFile == null) continue;
                buildSettings.add((MBuildSetting)mlibraryFile);
                toRemove.add(flag);
            }
        }
        ProjectImportUtils.removeStringsFromStringList(flags, toRemove);
        return buildSettings;
    }

    public static List<String> patternMatchSplitter(String string, Pattern pattern, IStringSplitter splitter) {
        ArrayList<String> strings = new ArrayList<String>();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            if (splitter == null) {
                strings.add(matcher.group());
                continue;
            }
            String[] splitStrings = splitter.splitString(matcher.group());
            strings.addAll(Arrays.asList(splitStrings));
        }
        return strings;
    }

    public static String patternMatchGetter(String string, Pattern pattern) {
        String matchString = "";
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            matchString = matcher.group();
        }
        return matchString;
    }

    public static List<String> findAllPatternMatches(String string, Pattern pattern) {
        ArrayList<String> matches = new ArrayList<String>();
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            matches.add(matcher.group());
        }
        return matches;
    }

    public static MMacroDefinition createMMacroDefinitionFromString(String macro, String language) {
        if (macro.isEmpty()) {
            return null;
        }
        String[] splitString = macro.split("=", 2);
        MMacroDefinition mmacro = ProjectModelFactory.eINSTANCE.createMMacroDefinition();
        mmacro.setName(splitString[0].trim());
        mmacro.setValue(splitString.length > 1 ? splitString[1].trim() : null);
        mmacro.setLanguageCompatibility(language);
        return mmacro;
    }

    public static MMacroDefinition createMMacroDefinitionFromString(String macro, String language, Map<String, String> variables, Pattern variablePattern, Collection<String> unconvertedVariables) {
        String variableReplacedMacro = ProjectImportUtils.replaceVariables(macro, variables);
        if (unconvertedVariables != null && variablePattern != null) {
            unconvertedVariables.addAll(ProjectImportUtils.findAllPatternMatches(variableReplacedMacro, variablePattern));
        }
        return ProjectImportUtils.createMMacroDefinitionFromString(variableReplacedMacro, language);
    }

    public static MLibraryPath createMLibraryPathFromString(String libraryPath, URI basePath) {
        String language = ELanguage.OBJ.toString();
        if ((libraryPath = libraryPath.trim().replaceAll("^\"|\"$", "").replace('\\', '/')).isEmpty()) {
            return null;
        }
        URI uri = new File(libraryPath).toURI();
        MLibraryPath mlibraryPath = ProjectModelFactory.eINSTANCE.createMLibraryPath();
        mlibraryPath.setLanguageCompatibility(language);
        try {
            uri = URIUtils.createAbsoluteURI((String)libraryPath);
            mlibraryPath.setUri(URIUtils.resolveURIFrom((URI)basePath, (URI)uri).toString());
        }
        catch (IOException iOException) {
            mlibraryPath.setUri(uri.toString());
        }
        return mlibraryPath;
    }

    public static MLibraryPath createMLibraryPathFromString(String libraryPath, URI basePath, Map<String, String> variables, Pattern variablePattern, Collection<String> unconvertedVariables) {
        String variablesReplaced = ProjectImportUtils.replaceVariables(libraryPath, variables);
        if (unconvertedVariables != null && variablePattern != null) {
            unconvertedVariables.addAll(ProjectImportUtils.findAllPatternMatches(variablesReplaced, variablePattern));
        }
        return ProjectImportUtils.createMLibraryPathFromString(variablesReplaced, basePath);
    }

    public static MLibraryFile createMLibraryFileFromString(String libraryPath, URI basePath) {
        String language = ELanguage.OBJ.toString();
        if ((libraryPath = libraryPath.trim().replaceAll("^\"|\"$", "").replace('\\', '/')).isEmpty()) {
            return null;
        }
        MLibraryFile mlibraryFile = ProjectModelFactory.eINSTANCE.createMLibraryFile();
        if (libraryPath.matches(LIBRARY_FILE_PATTERN)) {
            try {
                URI libURI = URIUtils.createAbsoluteURI((String)libraryPath);
                libURI = URIUtils.resolveURIFrom((URI)basePath, (URI)libURI);
                libraryPath = libURI.toString();
            }
            catch (IOException iOException) {}
            mlibraryFile.setUri(libraryPath);
        } else {
            mlibraryFile.setName(libraryPath);
        }
        mlibraryFile.setLanguageCompatibility(language);
        return mlibraryFile;
    }

    public static MLibraryFile createMLibraryFileFromString(String libraryPath, URI basePath, Map<String, String> variables, Pattern variablePattern, Collection<String> unconvertedVariables) {
        String variablesReplaced = ProjectImportUtils.replaceVariables(libraryPath, variables);
        if (unconvertedVariables != null && variablePattern != null) {
            unconvertedVariables.addAll(ProjectImportUtils.findAllPatternMatches(variablesReplaced, variablePattern));
        }
        return ProjectImportUtils.createMLibraryFileFromString(variablesReplaced, basePath);
    }

    public static MIncludePath createMIncludePathFromString(String includePath, URI basePath, String language) {
        MIncludePath minclude = ProjectModelFactory.eINSTANCE.createMIncludePath();
        String uriStr = ProjectImportUtils.formatPath(includePath, basePath, true);
        if (TextUtils.isEmpty((String)uriStr)) {
            return null;
        }
        minclude.setUri(uriStr);
        minclude.setLanguageCompatibility(language);
        return minclude;
    }

    public static String formatPath(String path, URI basePath, boolean isDir) {
        String uriStr;
        if ((path = path.trim().replaceAll("^\"|\"$", "").replace('\\', '/')).isEmpty()) {
            return "";
        }
        URI uri = URIUtils.createAbsoluteURI((String)path);
        try {
            String resolvedURI;
            uri = URIUtils.createAbsoluteURI((String)path);
            uriStr = resolvedURI = URIUtils.resolveURIFrom((URI)basePath, (URI)uri).toString();
        }
        catch (IOException iOException) {
            uriStr = uri.toString();
        }
        uriStr = ProjectImportUtils.standardizePaths(uriStr, isDir);
        return uriStr;
    }

    private static String standardizePaths(String uriStr, boolean isDir) {
        String prepend = null;
        if (((String)uriStr).startsWith("file:/") && HostUtils.isWindows()) {
            uriStr = ((String)uriStr).substring("file:/".length());
            prepend = "file:/";
        }
        uriStr = IPathUtils.createPath((String)uriStr).toString();
        if (prepend != null) {
            uriStr = prepend + (String)uriStr;
        }
        if (isDir && !((String)uriStr).endsWith("/")) {
            uriStr = (String)uriStr + "/";
        }
        return uriStr;
    }

    public static MIncludePath createMIncludePathFromString(String includePath, URI basePath, String language, Map<String, String> variables, Pattern variablePattern, Collection<String> unconvertedVariables) {
        String variablesReplaced = ProjectImportUtils.replaceVariables(includePath, variables);
        if (unconvertedVariables != null && variablePattern != null) {
            unconvertedVariables.addAll(ProjectImportUtils.findAllPatternMatches(variablesReplaced, variablePattern));
        }
        return ProjectImportUtils.createMIncludePathFromString(variablesReplaced, basePath, language);
    }

    public static String[] splitStringOnlyOutsideQuotes(String macroArgs, Character ... separators) {
        ArrayList<String> flagList = new ArrayList<String>();
        List<Character> separatorList = Arrays.asList(separators);
        int start_index = 0;
        boolean inside_quotes = false;
        int i = 0;
        while (i < macroArgs.length()) {
            Character c = Character.valueOf(macroArgs.charAt(i));
            if (c.equals(Character.valueOf('\"'))) {
                boolean escaped = false;
                if (i > 0) {
                    boolean bl = escaped = macroArgs.charAt(i - 1) == '\\';
                }
                if (!escaped) {
                    inside_quotes = !inside_quotes;
                }
            } else if (separatorList.contains(c) && start_index != i && !inside_quotes) {
                flagList.add(macroArgs.substring(start_index, i).trim());
                start_index = i + 1;
            }
            ++i;
        }
        String lastFlag = macroArgs.substring(start_index, macroArgs.length()).trim();
        if (lastFlag.length() > 0) {
            flagList.add(lastFlag);
        }
        return flagList.toArray(new String[0]);
    }

    public static String replaceOnlyOutsideQuotes(String inputString, String replaceWith, String ... matches) {
        boolean insideQuotes = false;
        List<String> matcher = Arrays.asList(matches);
        int size = matches[0].length();
        int i = 0;
        while (i < ((String)inputString).length()) {
            String subInput;
            if (((String)inputString).charAt(i) == '\"' || ((String)inputString).charAt(i) == '\'') {
                boolean bl = insideQuotes = !insideQuotes;
            }
            if (!insideQuotes && i < ((String)inputString).length() - size && matcher.contains(subInput = ((String)inputString).substring(i, i + size)) && !subInput.contains("\"")) {
                inputString = ((String)inputString).substring(0, i) + replaceWith + ((String)inputString).substring(i + size);
                --i;
            }
            ++i;
        }
        return inputString;
    }

    public static Map<Object, Integer> mapEnumStringToInt(Object ... objects) {
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        int i = 0;
        while (i < objects.length) {
            map.put(objects[i], i);
            ++i;
        }
        return map;
    }

    public static String getELanguageString(ELanguage ... eLanguages) {
        return TextUtils.catenateStrings((Object[])eLanguages, (String)" ");
    }

    public static String getELanguage(ImporterTool.ToolType toolType) {
        switch (toolType) {
            case ASSEMBLER: {
                return ELanguage.ASM.toString();
            }
            case COMPILER: {
                return ProjectImportUtils.getELanguageString(ELanguage.C, ELanguage.CPP);
            }
            case LINKER: 
            case TOOLCHAIN: {
                return ELanguage.OBJ.toString();
            }
        }
        return null;
    }

    public static void unmap(IProperty property, IDirectOptionMappingRegistry registry) {
        DirectOptionMappingFactory.with((IProperty)property).is(EMappingStatus.UNMAPPED).addTo((IOptionMappingRegistry)registry);
    }

    public static void unmap(IProperty property, IGenericOptionMappingRegistry registry) {
        GenericOptionMappingFactory.with((IProperty)property).is(EMappingStatus.UNMAPPED).addTo((IOptionMappingRegistry)registry);
    }

    public static String squashStringListToString(List<String> strings) {
        return TextUtils.catenateStrings(strings, (String)" ");
    }

    public static String replaceVariables(String string, Map<String, String> replacements) {
        if (replacements == null) {
            return string;
        }
        String replacedStr = string;
        for (String key : replacements.keySet()) {
            String replacementString = replacements.get(key);
            String quoteKey = Pattern.quote(key);
            replacedStr = replacedStr.replaceAll(quoteKey, replacementString);
        }
        return replacedStr;
    }

    public static List<String> replaceVariablesInList(List<String> strings, Map<String, String> replacements) {
        if (replacements == null) {
            return strings;
        }
        ArrayList<String> replacedList = new ArrayList<String>();
        for (String fromString : strings) {
            replacedList.add(ProjectImportUtils.replaceVariables(fromString, replacements));
        }
        return replacedList;
    }
}

