/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.external;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.silabs.ss.framework.project.api.core.ImportMode;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;

public final class SolutionImportResult {
    private static final SolutionImportResult EMPTY = new SolutionImportResult((ImmutableList<File>)ImmutableList.of(), (ImmutableSet<String>)ImmutableSet.of(), null);
    private final ImmutableList<File> locations;
    private final ImportMode importMode;
    private final ImmutableSet<String> disallowedTypes;

    public static SolutionImportResult empty() {
        return EMPTY;
    }

    private SolutionImportResult(ImmutableList<File> locations, ImmutableSet<String> disallowedTypes, ImportMode importMode) {
        this.locations = locations;
        this.disallowedTypes = disallowedTypes;
        this.importMode = importMode;
    }

    public ImmutableList<File> locations() {
        return this.locations;
    }

    public ImportMode importMode() {
        return this.importMode;
    }

    public ImmutableSet<String> disallowedTypes() {
        return this.disallowedTypes;
    }

    public static final class Builder {
        private final Collection<File> locations = new HashSet<File>();
        private ImportMode importMode;
        private final Collection<String> disallowedTypes = new HashSet<String>();

        public Builder addLocation(File location) {
            this.locations.add(location);
            return this;
        }

        public Collection<File> locations() {
            return this.locations;
        }

        public Builder setImportMode(ImportMode mode) {
            this.importMode = mode;
            return this;
        }

        public Builder disallowedTypes(String typeId) {
            this.disallowedTypes.add(typeId);
            return this;
        }

        public Builder disallowedTypes(Collection<String> typeIds) {
            this.disallowedTypes.addAll(typeIds);
            return this;
        }

        public Collection<String> disallowedTypes() {
            return this.disallowedTypes;
        }

        public SolutionImportResult build() {
            return new SolutionImportResult((ImmutableList<File>)ImmutableList.copyOf(this.locations), (ImmutableSet<String>)ImmutableSet.copyOf(this.disallowedTypes), this.importMode);
        }
    }
}

