/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.external.options;

import com.silabs.java.utils.annotation.ScriptReferenced;
import com.silabs.ss.framework.project.api.core.model.options.BaseGenericOptions;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.IPropertyGroup;
import com.silabs.ss.platform.api.descriptor.core.property.model.IPropertyRegistry;
import com.silabs.ss.platform.api.descriptor.core.property.model.Property;

@ScriptReferenced
public abstract class BaseGenericCompilerOptions
extends BaseGenericOptions {
    static IPropertyRegistry registry = Property.registry();
    public final IProperty ENABLE_MISC = registry.registerProperty(this.group(), "enable_misc", "boolean", "Boolean option to use miscellaneous options in command line");
    public final IProperty MISC = registry.registerProperty(this.group(), "misc", "stringList", "String definition of miscellaneous options");
    public final IProperty VARIABLE_MISC = registry.registerProperty(this.group(), "variable_misc", "stringList", "String definition of miscellaneous options that replace variables.");

    public abstract IPropertyGroup group();

    public abstract Preprocessor Preprocessor();

    public abstract Language Language();

    public abstract Debug Debug();

    public abstract Optimizer Optimizer();

    public abstract Output Output();

    public abstract Target Target();

    public abstract Warnings Warnings();

    public abstract Libraries Libraries();

    @ScriptReferenced
    public class Debug
    extends BaseGenericOptions {
        public final IProperty DEBUG_LEVEL;
        public final IProperty NO_BUILTIN;
        public final IProperty GENERATE_SYMBOLS;
        public final IProperty GENERATE_LINES;
        public final IProperty GENERATE_TYPES;
        public final IProperty GENERATE_MACROS;

        public Debug() {
            this.DEBUG_LEVEL = Debug.enumProp((IPropertyRegistry)registry, (IPropertyGroup)BaseGenericCompilerOptions.this.group(), (String)"debug_level", (String)"The debugging level of content", (String[])new String[]{"none", "minimal", "default", "maximum"});
            this.NO_BUILTIN = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "no_builtin", "boolean", "Always branch to builtin functions");
            this.GENERATE_SYMBOLS = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "generateSymbols", "boolean", "Tells whether symbols are stored in debug information.");
            this.GENERATE_LINES = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "generateLines", "boolean", "Tells whether line numbers / offsets are stored in debug information.");
            this.GENERATE_TYPES = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "generateTypes", "boolean", "Tells whether types are stored in debug information.");
            this.GENERATE_MACROS = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "generateMacros", "boolean", "Tells whether macros are stored in debug information.");
        }
    }

    @ScriptReferenced
    public class Language
    extends BaseGenericOptions {
        public final IProperty TRIGRAPHS;
        public final IProperty ENUMS_ALWAYS_INT;
        public final IProperty UNSIGNED_CHAR;

        public Language() {
            this.TRIGRAPHS = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "trigraphs", "boolean", "Enable ISO C trigraphs");
            this.ENUMS_ALWAYS_INT = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "enumsAlwaysInt", "boolean", "Tells whether enum types are always 'int' or the shortest representable type");
            this.UNSIGNED_CHAR = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "unsignedChar", "boolean", "Treat 'char' as unsigned, instead of signed");
        }
    }

    @ScriptReferenced
    public class Libraries
    extends BaseGenericOptions {
        public final IProperty NANO_C_LIBRARIES;

        public Libraries() {
            this.NANO_C_LIBRARIES = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "nano_c_libs", "boolean", "Should the nano libraries be used");
        }
    }

    @ScriptReferenced
    public class Optimizer
    extends BaseGenericOptions {
        public final IProperty OPTIMIZATION;
        public final IProperty OPTIMIZE_FOR_SIZE;
        public final IProperty OPTIMIZE_FOR_SPEED;
        public final IProperty INTRINSICS;
        public final IProperty OPTIMIZE_FOR_DEBUG;
        public final IProperty OPTIMIZE_FAST_MATH;
        public final IProperty DATA_SECTIONS;
        public final IProperty FUNCTION_SECTIONS;
        public final IProperty OMIT_FRAME_POINTER;
        public final IProperty STATIC_CLUSTERING;
        public final IProperty USE_VECTORIZATION;
        public final IProperty CONSTANT_FOLDING;
        public final IProperty JUMP_OPTIMIZING;
        public final IProperty DEAD_CODE_ELIMINATION;
        public final IProperty DATA_OVERLAYING;
        public final IProperty PEEPHOLE;
        public final IProperty REGISTER_VARIABLES;
        public final IProperty GLOBAL_REGISTER_COLORING;
        public final IProperty LOCAL_CSE;
        public final IProperty GLOBAL_CSE;
        public final IProperty SWITCH_OPTIMIZING;
        public final IProperty LOOP_INVARIANTS;
        public final IProperty LOOP_OPTIMIZING;
        public final IProperty SCHEDULING;
        public final IProperty TAIL_MERGING;
        public final IProperty EXTENDED_INDEX_ACCESS_OPTIMIZING;
        public final IProperty COMMON_BLOCK_SUBROUTINES;
        public final IProperty INLINING;
        public final IProperty AUTO_INLINE;

        public Optimizer() {
            this.OPTIMIZATION = Optimizer.enumProp((IPropertyRegistry)registry, (IPropertyGroup)BaseGenericCompilerOptions.this.group(), (String)"optimization", (String)"Optimization value", (String[])new String[]{"none", "low", "medium", "debug", "speed", "size"});
            this.OPTIMIZE_FOR_SIZE = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "optimizeForSize", "boolean", "Favor size over speed");
            this.OPTIMIZE_FOR_SPEED = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "optimizeForSpeed", "boolean", "Favor speed over size");
            this.INTRINSICS = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "intrinsics", "boolean", "Generate code for intrinsic functions (e.g. math, strlen, etc). rather than calling runtime functions");
            this.OPTIMIZE_FOR_DEBUG = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "optimizeForDebug", "boolean", "Suppress optimizations that make debugging more difficult");
            this.OPTIMIZE_FAST_MATH = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "fastMath", "boolean", "Enable optimizations that relax strict ANSI requirements about reordering floating point evaluation");
            this.DATA_SECTIONS = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "data_sections", "boolean", "Place each data item into its own section in the output file if the target supports arbitrary sections");
            this.FUNCTION_SECTIONS = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "function_sections", "boolean", "Place each function item into its own section in the output file if the target supports arbitrary sections");
            this.OMIT_FRAME_POINTER = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "omit_frame_pointer", "boolean", "Omit the frame pointer in functions that don\u2019t need one");
            this.STATIC_CLUSTERING = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "static_cluserting", "boolean", "Group all statics together");
            this.USE_VECTORIZATION = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "use_vectorization", "boolean", "Use Neon Vectorization instructions");
            this.CONSTANT_FOLDING = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "constantFolding", "boolean", "Fold expressions to constants");
            this.JUMP_OPTIMIZING = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "jumpOptimizing", "boolean", "Optimize jumps to jumps and/or favor short jump instructions");
            this.DEAD_CODE_ELIMINATION = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "deadCodeElimination", "boolean", "Eliminate dead code inside functions");
            this.DATA_OVERLAYING = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "dataOverlaying", "boolean", "Overlay global data when it is not used at the same time by different functions");
            this.PEEPHOLE = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "peephole", "boolean", "Perform peephole optimization");
            this.REGISTER_VARIABLES = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "registerVariables", "boolean", "Place variables in registers rather than on the stack (e.g. local register coloring)");
            this.GLOBAL_REGISTER_COLORING = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "globalRegisterColoring", "boolean", "Attempt to use registers between function calls");
            this.LOCAL_CSE = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "localCSE", "boolean", "Local common subexpression elimination");
            this.GLOBAL_CSE = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "globalCSE", "boolean", "Global common subexpression elimination");
            this.SWITCH_OPTIMIZING = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "switchOptimizing", "boolean", "Optimize switch statements (e.g. to use jump tables)");
            this.LOOP_INVARIANTS = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "loopInvariants", "boolean", "Move loop invariants out of loops");
            this.LOOP_OPTIMIZING = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "loopOptimizing", "boolean", "Non-trivial loop optimizations (loop rotation, etc.)");
            this.SCHEDULING = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "scheduling", "boolean", "Instruction scheduling");
            this.TAIL_MERGING = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "tailMerging", "boolean", "Merge common tails of functions");
            this.EXTENDED_INDEX_ACCESS_OPTIMIZING = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "extendedIndexAccessOptimizing", "boolean", "DPTR is used for register variables where appropriate. Pointer and array access are optimized for both execution speed and code size.");
            this.COMMON_BLOCK_SUBROUTINES = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "commonBlockSubroutines", "boolean", "Create subroutines from common instruction sequences inside functions");
            this.INLINING = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "inlining", "boolean", "Perform any inlining of functions (if disabled, even those marked 'inline' are ignored)");
            this.AUTO_INLINE = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "autoInline", "boolean", "Automatically inline small functions");
        }
    }

    @ScriptReferenced
    public class Output
    extends BaseGenericOptions {
        public final IProperty GENERATE_ASSEMBLY;
        public final IProperty GENERATE_PREPROCESSED;
        public final IProperty GENERATE_SECURE_CODE;

        public Output() {
            this.GENERATE_ASSEMBLY = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "generateAssembly", "boolean", "Tells whether an assembly listing file is created for each source file (this may or may not be compilable).");
            this.GENERATE_PREPROCESSED = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "generatePreprocessed", "boolean", "Tells whether a preprocessed file is created for each source file.");
            this.GENERATE_SECURE_CODE = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "generateSecureCode", "boolean", "Generate secure code as per the 'ARMv8-M Security Extensions: Requirements on Development Tools Engineering Specification'");
        }
    }

    @ScriptReferenced
    public class Preprocessor
    extends BaseGenericOptions {
        public final IProperty DEFINE_MACROS;
        public final IProperty UNDEFINE_MACROS;
        public final IProperty NO_SYSTEM_MACROS;
        public final IProperty USER_INCLUDE_PATHS;
        public final IProperty SYSTEM_INCLUDE_PATHS;
        public final IProperty NO_STANDARD_INCLUDES;
        public final IProperty PREFIX_FILES;
        public final IProperty PREINCLUDE;

        public Preprocessor() {
            this.DEFINE_MACROS = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "defineMacros", "defineList", "Provides a list of name/value definitions for implicit #define(s)");
            this.UNDEFINE_MACROS = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "undefineMacros", "stringList", "Provides a list of names for macros to undefine");
            this.NO_SYSTEM_MACROS = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "noSystemMacros", "boolean", "Suppress #defines built in to the compiler (e.g. system or architecture macros)");
            this.USER_INCLUDE_PATHS = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "userIncludePaths", "uriList", "Provides a list of #include paths for lookup with #include \"...\" or <...>");
            this.SYSTEM_INCLUDE_PATHS = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "systemIncludePaths", "uriList", "Provides a list of #include paths for lookup with #include <...>");
            this.NO_STANDARD_INCLUDES = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "noStandardIncludes", "boolean", "Suppress #include paths built in to the compiler (e.g. system runtime or compiler headers)");
            this.PREFIX_FILES = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "prefixFiles", "uriList", "Provides a list of files to #include before every compilation unit");
            this.PREINCLUDE = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "preinclude", "stringList", "Provides a list of headers to pre-include before every compilation unit");
        }
    }

    @ScriptReferenced
    public class Target
    extends BaseGenericOptions {
        public final IProperty PIC;
        public final IProperty PID;
        public final IProperty FLOAT_ABI;
        public final IProperty ENABLE_FPU;

        public Target() {
            this.PIC = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "pic", "boolean", "Generate position-independent code");
            this.PID = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "pid", "boolean", "Generate position-independent data");
            this.FLOAT_ABI = Target.enumProp((IPropertyRegistry)registry, (IPropertyGroup)BaseGenericCompilerOptions.this.group(), (String)"float_abi", (String)"Float type", (String[])new String[]{"soft", "softfp", "hard"});
            this.ENABLE_FPU = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "enable_fpu", "boolean", "Float type");
        }
    }

    @ScriptReferenced
    public class Warnings
    extends BaseGenericOptions {
        public final IProperty WARNINGS_ARE_ERRORS;
        public final IProperty INCORRECT_CODE;
        public final IProperty EXTRA;
        public final IProperty NON_STANDARD;
        public final IProperty SYNTAX_ONLY;
        public final IProperty SUPPRESS_WARNINGS;
        public final IProperty IMPLICIT_CONVERSIONS;
        public final IProperty STACK_PROTECTION;

        public Warnings() {
            this.WARNINGS_ARE_ERRORS = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "warningsAreErrors", "boolean", "Converts any warning into an error");
            registry.aliasProperty(BaseGenericCompilerOptions.this.group().getId() + ".warnings.are_errors", this.WARNINGS_ARE_ERRORS);
            this.INCORRECT_CODE = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "incorrectCode", "boolean", "Emit warnings for constructs that are generally incorrect code");
            registry.aliasProperty(BaseGenericCompilerOptions.this.group().getId() + ".warnings.all", this.INCORRECT_CODE);
            this.EXTRA = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "extra", "boolean", "Emit extra warnings for other code constructs that may indicate sloppy code, incorrect refactoring, etc.");
            registry.aliasProperty(BaseGenericCompilerOptions.this.group().getId() + ".warnings.extra", this.EXTRA);
            this.NON_STANDARD = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "nonStandard", "boolean", "Emit warnings for constructs not allowed by the language standard");
            registry.aliasProperty(BaseGenericCompilerOptions.this.group().getId() + ".warnings.pedantic", this.NON_STANDARD);
            this.SYNTAX_ONLY = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "syntaxOnly", "boolean", "Only check syntax; do not actually compile");
            this.SUPPRESS_WARNINGS = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "suppressWarnings", "boolean", "Suppress all warnings");
            this.IMPLICIT_CONVERSIONS = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "implicitConversions", "boolean", "Emit warnings for implicit conversions between types");
            this.STACK_PROTECTION = registry.registerProperty(BaseGenericCompilerOptions.this.group(), "stackProtection", "boolean", "Turn on stack protection");
        }
    }
}

